/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client.hosturlmap;

import io.smallrye.config.RelocateConfigSourceInterceptor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MinioHostFallbackInterceptor
extends RelocateConfigSourceInterceptor {
    private static Pattern pattern = Pattern.compile("quarkus\\.minio(\\..*)?\\.url");

    public MinioHostFallbackInterceptor() {
        super(MinioHostFallbackInterceptor::keyEvaluator);
    }

    private static String keyEvaluator(String key) {
        Matcher matcher = pattern.matcher(key);
        if (matcher.matches()) {
            return "quarkus.minio%s.host".formatted(matcher.group(1) != null ? matcher.group(1) : "");
        }
        return key;
    }
}

