/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mockserver.devservices;

import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public class ContainerLogger
extends BaseConsumer<Slf4jLogConsumer> {
    private static final String LINE_BREAK_AT_END_REGEX = "((\\r?\\n)|(\\r))$";
    private final String prefix;

    public static ContainerLogger create(String prefix) {
        return new ContainerLogger(prefix);
    }

    private ContainerLogger(String prefix) {
        this.prefix = "[" + prefix + "] ";
    }

    public void accept(OutputFrame outputFrame) {
        OutputFrame.OutputType outputType = outputFrame.getType();
        String utf8String = outputFrame.getUtf8String();
        utf8String = utf8String.replaceAll(LINE_BREAK_AT_END_REGEX, "");
        switch (outputType) {
            case END: {
                break;
            }
            case STDOUT: {
                System.out.println(this.prefix + utf8String);
                break;
            }
            case STDERR: {
                System.err.println(this.prefix + utf8String);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected outputType " + outputType);
            }
        }
    }
}

