/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mockserver.devservices;

import io.quarkiverse.mockserver.devservices.ContainerLogger;
import io.quarkiverse.mockserver.devservices.ContainerShutdownCloseable;
import io.quarkiverse.mockserver.devservices.DevServicesConfig;
import io.quarkiverse.mockserver.devservices.MockServerBuildTimeConfig;
import io.quarkiverse.mockserver.runtime.MockServerConfig;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MockServerContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;

public class DevServicesMockServerProcessor {
    private static final Logger log = Logger.getLogger(DevServicesMockServerProcessor.class);
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-mockserver";
    private static final int MOCKSERVER_EXPOSED_PORT = 1080;
    private static final ContainerLocator containerLocator = new ContainerLocator("quarkus-dev-service-mockserver", 1080);
    private static final String FEATURE_NAME = "mock-server";
    private static final String DEFAULT_MOCKSERVER_CONTAINER_IMAGE = "mockserver/mockserver";
    private static final String DEFAULT_MOCKSERVER_VERSION = "5.15.0";
    private static final DockerImageName MOCKSERVER_IMAGE_NAME = DockerImageName.parse((String)"mockserver/mockserver").withTag("5.15.0");
    private static volatile DevServicesResultBuildItem.RunningDevService devServices;
    private static volatile MockServerBuildTimeConfig.DevServiceConfiguration capturedDevServicesConfiguration;
    private static volatile boolean first;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public DevServicesResultBuildItem startMockServerContainers(LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, MockServerBuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        MockServerBuildTimeConfig.DevServiceConfiguration currentDevServicesConfiguration = config.defaultDevService;
        if (devServices != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !currentDevServicesConfiguration.equals(capturedDevServicesConfiguration);
            if (!restartRequired) {
                return devServices.toBuildItem();
            }
            try {
                devServices.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop MockServer container", e);
            }
            devServices = null;
            capturedDevServicesConfiguration = null;
        }
        capturedDevServicesConfiguration = currentDevServicesConfiguration;
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "MockServer Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            devServices = this.startContainer(dockerStatusBuildItem, currentDevServicesConfiguration.devservices, launchMode.getLaunchMode(), !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (devServices == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devServices == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devServices != null) {
                    try {
                        devServices.close();
                    }
                    catch (Throwable t) {
                        log.error((Object)"Failed to stop MockServer", t);
                    }
                }
                first = true;
                devServices = null;
                capturedDevServicesConfiguration = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        if (devServices.isOwner()) {
            log.infof("The mock-server server is ready to accept connections on http://%s:%s", devServices.getConfig().get(MockServerConfig.CLIENT_HOST), devServices.getConfig().get(MockServerConfig.CLIENT_PORT));
            log.infof("The mock-server dashboard http://%s:%s/mockserver/dashboard", devServices.getConfig().get(MockServerConfig.CLIENT_HOST), devServices.getConfig().get(MockServerConfig.CLIENT_PORT));
        }
        return devServices.toBuildItem();
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, DevServicesConfig devServicesConfig, LaunchMode launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        if (!devServicesConfig.enabled) {
            log.debug((Object)"Not starting devservices for rest client as it has been disabled in the config");
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warnf("Please configure '%s' or get a working MockServer instance", (Object)MockServerConfig.ENDPOINT);
            return null;
        }
        DockerImageName tmp = MOCKSERVER_IMAGE_NAME;
        if (devServicesConfig.imageName.isPresent()) {
            tmp = DockerImageName.parse((String)devServicesConfig.imageName.get()).asCompatibleSubstituteFor(DEFAULT_MOCKSERVER_CONTAINER_IMAGE);
        }
        DockerImageName dockerImageName = tmp;
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultMockServerSupplier = () -> {
            QuarkusPortMockServerContainer container = new QuarkusPortMockServerContainer(dockerImageName, devServicesConfig.port, launchMode == LaunchMode.DEVELOPMENT ? devServicesConfig.serviceName : null, useSharedNetwork);
            timeout.ifPresent(arg_0 -> ((QuarkusPortMockServerContainer)container).withStartupTimeout(arg_0));
            if (devServicesConfig.log) {
                container.withLogConsumer((Consumer)((Object)ContainerLogger.create(devServicesConfig.serviceName)));
            }
            if (devServicesConfig.configFile.isPresent()) {
                String configFile = devServicesConfig.configFile.get();
                if (devServicesConfig.configClassPath) {
                    container.withClasspathResourceMapping(configFile, "/config/mockserver.properties", BindMode.READ_ONLY);
                    log.infof("MockServer configuration local file '%s' mount to '/config/mockserver.properties' container file.", (Object)"MockServer configuration class-path file '%s' mount to '/config/mockserver.properties' container file.", (Object)configFile);
                } else if (Files.isRegularFile(Path.of(configFile, new String[0]), new LinkOption[0])) {
                    container.withFileSystemBind(configFile, "/config/mockserver.properties", BindMode.READ_ONLY);
                    log.infof("MockServer configuration local file '%s' mount to '/config/mockserver.properties' container file.", (Object)configFile);
                } else {
                    log.warnf("MockServer configuration local file '%s' is regular file.", (Object)configFile);
                }
            }
            if (devServicesConfig.configDir.isPresent()) {
                String configDir = devServicesConfig.configDir.get();
                Path path = Path.of(configDir, new String[0]);
                if (devServicesConfig.configClassPath) {
                    container.withClasspathResourceMapping(configDir, "/" + path.getFileName(), BindMode.READ_ONLY);
                    log.infof("MockServer configuration class-path directory '%s' mount to '/%s' container directory.", (Object)configDir, (Object)path.getFileName());
                } else if (Files.isDirectory(path, new LinkOption[0])) {
                    container.withFileSystemBind(configDir, "/" + path.getFileName(), BindMode.READ_ONLY);
                    log.infof("MockServer configuration local directory '%s' mount to '/%s' container directory.", (Object)configDir, (Object)path.getFileName());
                } else {
                    log.warnf("MockServer configuration local directory '%s' is not directory.", (Object)configDir);
                }
            }
            if (devServicesConfig.reuse) {
                container.withReuse(true);
            }
            container.start();
            return new DevServicesResultBuildItem.RunningDevService(FEATURE_NAME, container.getContainerId(), (Closeable)new ContainerShutdownCloseable((GenericContainer<?>)container, FEATURE_NAME), Map.of(MockServerConfig.HOST, container.getDevHost(), MockServerConfig.PORT, "" + container.getDevPort(), MockServerConfig.ENDPOINT, container.getDevEndpoint(), MockServerConfig.CLIENT_HOST, container.getHost(), MockServerConfig.CLIENT_PORT, "" + container.getServerPort()));
        };
        return containerLocator.locateContainer(devServicesConfig.serviceName, devServicesConfig.shared, launchMode).map(containerAddress -> new DevServicesResultBuildItem.RunningDevService(FEATURE_NAME, containerAddress.getId(), null, Map.of(MockServerConfig.HOST, containerAddress.getHost(), MockServerConfig.PORT, "" + containerAddress.getPort(), MockServerConfig.CLIENT_HOST, containerAddress.getHost(), MockServerConfig.CLIENT_PORT, "" + containerAddress.getPort(), MockServerConfig.ENDPOINT, String.format("http://%s:%d", containerAddress.getHost(), containerAddress.getPort())))).orElseGet(defaultMockServerSupplier);
    }

    static {
        first = true;
    }

    private static class QuarkusPortMockServerContainer
    extends MockServerContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusPortMockServerContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, String serviceName, boolean useSharedNetwork) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            if (serviceName != null) {
                this.withLabel(DevServicesMockServerProcessor.DEV_SERVICE_LABEL, serviceName);
            }
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)DevServicesMockServerProcessor.FEATURE_NAME);
                return;
            }
            this.withNetwork(Network.SHARED);
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 1080);
            } else {
                this.addExposedPort(1080);
            }
        }

        public String getDevEndpoint() {
            if (this.useSharedNetwork) {
                return String.format("http://%s:%d", this.hostName, 1080);
            }
            return super.getEndpoint();
        }

        public int getDevPort() {
            if (this.useSharedNetwork) {
                return 1080;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getServerPort();
        }

        public String getDevHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }
    }
}

