/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mockserver.devservices;

import io.quarkiverse.mockserver.devservices.MockServerBuildTimeConfig;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import java.util.List;
import java.util.Map;

public class DevUIMockServerProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    public CardPageBuildItem pages(List<DevServicesResultBuildItem> devServicesResultBuildItemList, MockServerBuildTimeConfig config) {
        DevServicesResultBuildItem mockServerService;
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        if (devServicesResultBuildItemList != null && (mockServerService = (DevServicesResultBuildItem)devServicesResultBuildItemList.stream().filter(x -> config.defaultDevService().devservices().serviceName().equals(x.getName())).findFirst().orElse(null)) != null) {
            Map keys = mockServerService.getConfig();
            String url = String.format("http://%s:%s/mockserver/dashboard", keys.get("quarkus.mockserver.client.host"), keys.get("quarkus.mockserver.client.port"));
            cardPageBuildItem.addPage((PageBuilder)Page.externalPageBuilder((String)"Dashboard").url(url).isHtmlContent().icon("font-awesome-solid:sliders"));
            cardPageBuildItem.addPage((PageBuilder)Page.externalPageBuilder((String)"External dashboard").url(url, url).doNotEmbed().icon("font-awesome-solid:share-from-square"));
        }
        return cardPageBuildItem;
    }
}

