/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.moneta.convert;

import io.quarkiverse.moneta.convert.ECBRateReadingHandler;
import java.io.InputStream;
import java.math.MathContext;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryException;
import javax.money.NumberValue;
import javax.money.convert.ConversionQuery;
import javax.money.convert.CurrencyConversionException;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.spi.Bootstrap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.javamoney.moneta.convert.ExchangeRateBuilder;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.loader.LoadDataInformation;
import org.javamoney.moneta.spi.loader.LoaderService;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

abstract class ECBAbstractRateProvider
extends AbstractRateProvider
implements LoaderService.Listener {
    private static final Logger LOG = Logger.getLogger(ECBAbstractRateProvider.class.getName());
    private static final String BASE_CURRENCY_CODE = "EUR";
    public static final CurrencyUnit BASE_CURRENCY = Monetary.getCurrency((String)"EUR", (String[])new String[0]);
    protected final Map<LocalDate, Map<String, ExchangeRate>> rates = new ConcurrentHashMap<LocalDate, Map<String, ExchangeRate>>();
    protected volatile String loadState;
    protected volatile CountDownLatch loadLock = new CountDownLatch(1);
    private final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private final ProviderContext context;
    protected final String remoteResource;

    ECBAbstractRateProvider(ProviderContext context, String remoteRes) {
        super(context);
        this.remoteResource = remoteRes;
        this.context = context;
        this.saxParserFactory.setNamespaceAware(false);
        this.saxParserFactory.setValidating(false);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        if (!loader.isResourceRegistered(this.getDataId())) {
            loader.registerData(this.getDefaultLoadData());
        }
        loader.addLoaderListener((LoaderService.Listener)this, new String[]{this.getDataId()});
        loader.loadDataAsync(this.getDataId());
    }

    protected abstract String getDataId();

    protected abstract LoadDataInformation getDefaultLoadData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newDataLoaded(String resourceId, InputStream is) {
        int oldSize = this.rates.size();
        try {
            SAXParser parser = this.saxParserFactory.newSAXParser();
            InputSource src = new InputSource(new URL(this.remoteResource).openStream());
            parser.parse(src, (DefaultHandler)new ECBRateReadingHandler(this.rates, this.getContext()));
            int newSize = this.rates.size();
            this.loadState = "Loaded " + resourceId + " exchange rates for days:" + (newSize - oldSize);
            LOG.config(this.loadState);
        }
        catch (Exception e) {
            this.loadState = "Last Error during data load: " + e.getMessage();
            LOG.log(Level.FINEST, "Error during data load.", e);
        }
        finally {
            this.loadLock.countDown();
        }
    }

    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        Objects.requireNonNull(conversionQuery);
        try {
            if (this.loadLock.await(30L, TimeUnit.SECONDS)) {
                if (this.rates.isEmpty()) {
                    return null;
                }
                RateResult result = this.findExchangeRate(conversionQuery);
                ExchangeRateBuilder builder = this.getBuilder(conversionQuery);
                ExchangeRate sourceRate = result.targets.get(conversionQuery.getBaseCurrency().getCurrencyCode());
                ExchangeRate target = result.targets.get(conversionQuery.getCurrency().getCurrencyCode());
                return this.createExchangeRate(conversionQuery, builder, sourceRate, target);
            }
            throw new MonetaryException("Failed to load currency conversion data: " + this.loadState);
        }
        catch (InterruptedException e) {
            throw new MonetaryException("Failed to load currency conversion data: Load task has been interrupted.", (Throwable)e);
        }
    }

    private RateResult findExchangeRate(ConversionQuery conversionQuery) {
        LocalDate[] dates = this.getQueryDates(conversionQuery);
        if (dates == null) {
            Comparator comparator = Comparator.naturalOrder();
            LocalDate date2 = (LocalDate)this.rates.keySet().stream().max(comparator).orElseThrow(() -> new MonetaryException("There is not more recent exchange rate to  rate on ECBRateProvider."));
            return new RateResult(this.rates.get(date2));
        }
        for (LocalDate localDate : dates) {
            Map<String, ExchangeRate> targets = this.rates.get(localDate);
            if (!Objects.nonNull(targets)) continue;
            return new RateResult(targets);
        }
        String datesOnErros = Stream.of(dates).map(date -> date.format(DateTimeFormatter.ISO_LOCAL_DATE)).collect(Collectors.joining(","));
        throw new MonetaryException("There is no exchange on day " + datesOnErros + " to rate to  rate on ECBRateProvider.");
    }

    private ExchangeRate createExchangeRate(ConversionQuery query, ExchangeRateBuilder builder, ExchangeRate sourceRate, ExchangeRate target) {
        if (this.areBothBaseCurrencies(query)) {
            builder.setFactor(DefaultNumberValue.ONE);
            return builder.build();
        }
        if (BASE_CURRENCY_CODE.equals(query.getCurrency().getCurrencyCode())) {
            if (Objects.isNull(sourceRate)) {
                return null;
            }
            return this.reverse(sourceRate);
        }
        if (BASE_CURRENCY_CODE.equals(query.getBaseCurrency().getCurrencyCode())) {
            return target;
        }
        ExchangeRate rate1 = this.getExchangeRate(query.toBuilder().setTermCurrency(Monetary.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).build());
        ExchangeRate rate2 = this.getExchangeRate(query.toBuilder().setBaseCurrency(Monetary.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).setTermCurrency(query.getCurrency()).build());
        if (Objects.nonNull(rate1) && Objects.nonNull(rate2)) {
            builder.setFactor(ECBAbstractRateProvider.multiply((NumberValue)rate1.getFactor(), (NumberValue)rate2.getFactor()));
            builder.setRateChain(new ExchangeRate[]{rate1, rate2});
            return builder.build();
        }
        throw new CurrencyConversionException(query.getBaseCurrency(), query.getCurrency(), sourceRate.getContext());
    }

    private boolean areBothBaseCurrencies(ConversionQuery query) {
        return BASE_CURRENCY_CODE.equals(query.getBaseCurrency().getCurrencyCode()) && BASE_CURRENCY_CODE.equals(query.getCurrency().getCurrencyCode());
    }

    private ExchangeRateBuilder getBuilder(ConversionQuery query) {
        ExchangeRateBuilder builder = new ExchangeRateBuilder(this.getExchangeContext("ecb.digit.fraction"));
        builder.setBase(query.getBaseCurrency());
        builder.setTerm(query.getCurrency());
        return builder;
    }

    private ExchangeRate reverse(ExchangeRate rate) {
        if (Objects.isNull(rate)) {
            throw new IllegalArgumentException("Rate null is not reversible.");
        }
        return new ExchangeRateBuilder(rate).setRate(rate).setBase(rate.getCurrency()).setTerm(rate.getBaseCurrency()).setFactor(ECBAbstractRateProvider.divide((NumberValue)DefaultNumberValue.ONE, (NumberValue)rate.getFactor(), (MathContext)MathContext.DECIMAL64)).build();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "{ context: " + String.valueOf(this.context) + "}";
    }

    private class RateResult {
        private final Map<String, ExchangeRate> targets;

        RateResult(Map<String, ExchangeRate> targets) {
            this.targets = targets;
        }
    }
}

