/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.morphia.deployment;

import dev.morphia.Datastore;
import dev.morphia.annotations.AlsoLoad;
import dev.morphia.annotations.CappedAt;
import dev.morphia.annotations.Collation;
import dev.morphia.annotations.Converters;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.EntityListeners;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Handler;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.IdGetter;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.Indexes;
import dev.morphia.annotations.LoadOnly;
import dev.morphia.annotations.NotSaved;
import dev.morphia.annotations.PostLoad;
import dev.morphia.annotations.PostPersist;
import dev.morphia.annotations.PreLoad;
import dev.morphia.annotations.PrePersist;
import dev.morphia.annotations.Property;
import dev.morphia.annotations.Reference;
import dev.morphia.annotations.Text;
import dev.morphia.annotations.Transient;
import dev.morphia.annotations.Validation;
import dev.morphia.annotations.Version;
import dev.morphia.mapping.codec.references.ReferenceCodec;
import io.quarkiverse.morphia.MorphiaConfig;
import io.quarkiverse.morphia.MorphiaRecorder;
import io.quarkiverse.morphia.deployment.MorphiaEntitiesBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.mongodb.MongoClientName;
import io.quarkus.mongodb.deployment.MongoClientNameBuildItem;
import io.quarkus.mongodb.runtime.MongoClientBeanUtil;
import io.quarkus.mongodb.runtime.MongoClientRecorder;
import io.quarkus.mongodb.runtime.MongodbConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.codecs.Codec;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.jetbrains.annotations.NotNull;

public class MorphiaProcessor {
    private static final List<DotName> MAPPED_TYPE_ANNOTATIONS = List.of(DotName.createSimple((String)Entity.class.getName()), DotName.createSimple((String)Embedded.class.getName()));
    private static final String FEATURE = "quarkus-morphia";
    public static final DotName MONGO_CLIENT_NAME = DotName.createSimple((String)MongoClientName.class.getName());
    private static final String ENTITY_MODEL_IMPORTER = "dev.morphia.mapping.EntityModelImporter";

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void datastoreRecorder(MongoClientRecorder clientRecorder, MongodbConfig mongodbConfig, MorphiaRecorder recorder, MorphiaConfig config, MorphiaEntitiesBuildItem entitiesBuildItem, List<MongoClientNameBuildItem> mongoClientNames, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<ServiceProviderBuildItem> items) {
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Datastore.class).scope(ApplicationScoped.class)).supplier(recorder.datastoreSupplier(clientRecorder.mongoClientSupplier("<default>", mongodbConfig), config, entitiesBuildItem.getNames(), "<default>")).setRuntimeInit().done());
        for (MongoClientNameBuildItem mongoClientName : mongoClientNames) {
            String clientName = mongoClientName.getName();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Datastore.class).scope(ApplicationScoped.class)).supplier(recorder.datastoreSupplier(clientRecorder.mongoClientSupplier(clientName, mongodbConfig), config, entitiesBuildItem.getNames(), clientName)).setRuntimeInit();
            if (MongoClientBeanUtil.isDefault((String)clientName)) {
                configurator.addQualifier(Default.class);
            } else {
                configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)clientName).done();
                if (mongoClientName.isAddQualifier()) {
                    configurator.addQualifier().annotation(MONGO_CLIENT_NAME).addValue("value", (Object)clientName).done();
                }
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
        }
        items.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ENTITY_MODEL_IMPORTER));
    }

    @BuildStep
    public void registerReflectiveItems(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<GeneratedResourceBuildItem> resourceItems) throws IOException {
        this.registerWrapperArrays(reflectiveClasses);
        org.jboss.jandex.Index index = this.indexJar();
        this.registerImplementors(index, reflectiveClasses, DotName.createSimple((String)Codec.class.getName()));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{ReferenceCodec.class}));
        this.registerAnnotations(reflectiveClasses);
    }

    private void registerAnnotations(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{AlsoLoad.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{CappedAt.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Collation.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Converters.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Embedded.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Entity.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{EntityListeners.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Field.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Handler.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Id.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{IdGetter.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Indexed.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Index.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Indexes.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{IndexOptions.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{LoadOnly.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{NotSaved.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{PostLoad.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{PostPersist.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{PreLoad.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{PrePersist.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Property.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Reference.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Text.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Transient.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Validation.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{Version.class}));
    }

    @NotNull
    private org.jboss.jandex.Index indexJar() throws IOException {
        URL location = Datastore.class.getProtectionDomain().getCodeSource().getLocation();
        Indexer indexer = new Indexer();
        JarIndexer.createJarIndex((File)new File(location.getFile()), (Indexer)indexer, (boolean)false, (boolean)false, (boolean)false);
        return indexer.complete();
    }

    private void registerImplementors(org.jboss.jandex.Index index, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, DotName type) {
        Set set = index.getAllKnownImplementors(type);
        set.forEach(codec -> this.registerImplementors(index, reflectiveClasses, codec.name()));
        this.registerSubclasses(index, reflectiveClasses, type);
    }

    @BuildStep
    public MorphiaEntitiesBuildItem registerMappedTypes(CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        ArrayList<String> list = new ArrayList<String>();
        IndexView index = indexBuildItem.getIndex();
        for (DotName annotation : MAPPED_TYPE_ANNOTATIONS) {
            List<ClassInfo> classes = index.getKnownClasses().stream().filter(info -> info.classAnnotation(annotation) != null).collect(Collectors.toList());
            classes.forEach(info -> {
                reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{info.name().toString()}));
                list.add(info.name().toString());
            });
        }
        return new MorphiaEntitiesBuildItem(list);
    }

    private void registerSubclasses(org.jboss.jandex.Index index, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, DotName type) {
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{type.toString()}));
        index.getAllKnownSubclasses(type).forEach(codec -> this.registerSubclasses(index, reflectiveClasses, type));
    }

    private void registerWrapperArrays(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{Boolean[].class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{Byte[].class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{Character[].class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{Double[].class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{Float[].class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{Integer[].class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{Long[].class}));
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }
}

