/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mybatis.deployment;

import io.quarkiverse.mybatis.deployment.ConfigurationCustomizerBuildItem;
import io.quarkiverse.mybatis.deployment.ConfigurationFactoryBuildItem;
import io.quarkiverse.mybatis.deployment.MyBatisMappedJdbcTypeBuildItem;
import io.quarkiverse.mybatis.deployment.MyBatisMappedTypeBuildItem;
import io.quarkiverse.mybatis.deployment.MyBatisMapperBuildItem;
import io.quarkiverse.mybatis.deployment.MyBatisXmlConfigBuildItem;
import io.quarkiverse.mybatis.deployment.SqlSessionFactoryBuildItem;
import io.quarkiverse.mybatis.deployment.SqlSessionFactoryBuilderBuildItem;
import io.quarkiverse.mybatis.deployment.SqlSessionManagerBuildItem;
import io.quarkiverse.mybatis.deployment.XMLConfigBuilderBuildItem;
import io.quarkiverse.mybatis.runtime.ConfigurationFactory;
import io.quarkiverse.mybatis.runtime.MyBatisConfigurationFactory;
import io.quarkiverse.mybatis.runtime.MyBatisRecorder;
import io.quarkiverse.mybatis.runtime.MyBatisXMLConfigDelegateBuilder;
import io.quarkiverse.mybatis.runtime.TransactionalSqlSession;
import io.quarkiverse.mybatis.runtime.XMLConfigDelegateBuilder;
import io.quarkiverse.mybatis.runtime.config.MyBatisDataSourceRuntimeConfig;
import io.quarkiverse.mybatis.runtime.config.MyBatisRuntimeConfig;
import io.quarkiverse.mybatis.runtime.meta.MapperDataSource;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Overridable;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.cache.decorators.LruCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.javassist.util.proxy.ProxyFactory;
import org.apache.ibatis.scripting.defaults.RawLanguageDriver;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.type.EnumTypeHandler;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class MyBatisProcessor {
    private static final Logger LOG = Logger.getLogger(MyBatisProcessor.class);
    private static final String FEATURE = "mybatis";
    private static final DotName MYBATIS_MAPPER = DotName.createSimple((String)Mapper.class.getName());
    private static final DotName MYBATIS_TYPE_HANDLER = DotName.createSimple((String)MappedTypes.class.getName());
    private static final DotName MYBATIS_JDBC_TYPE_HANDLER = DotName.createSimple((String)MappedJdbcTypes.class.getName());
    private static final DotName MYBATIS_MAPPER_DATA_SOURCE = DotName.createSimple((String)MapperDataSource.class.getName());

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void runtimeInitialized(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInit) {
        runtimeInit.produce((BuildItem)new RuntimeInitializedClassBuildItem("org.apache.ibatis.logging.log4j.Log4jImpl"));
    }

    @BuildStep
    void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{ProxyFactory.class, XMLLanguageDriver.class, RawLanguageDriver.class, SelectProvider.class, UpdateProvider.class, InsertProvider.class, DeleteProvider.class, Result.class, Results.class, ResultType.class, ResultMap.class, EnumTypeHandler.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{PerpetualCache.class, LruCache.class}));
    }

    @BuildStep
    @Overridable
    void addMyBatisMappers(BuildProducer<MyBatisMapperBuildItem> mappers, BuildProducer<ReflectiveClassBuildItem> reflective, BuildProducer<NativeImageProxyDefinitionBuildItem> proxy, CombinedIndexBuildItem indexBuildItem) {
        for (AnnotationInstance i : indexBuildItem.getIndex().getAnnotations(MYBATIS_MAPPER)) {
            if (i.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            DotName dotName = i.target().asClass().name();
            reflective.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{dotName.toString()}));
            proxy.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{dotName.toString()}));
            Optional<AnnotationInstance> mapperDatasource = i.target().asClass().annotationsMap().entrySet().stream().filter(entry -> ((DotName)entry.getKey()).equals((Object)MYBATIS_MAPPER_DATA_SOURCE)).map(Map.Entry::getValue).map(annotationList -> (AnnotationInstance)annotationList.get(0)).findFirst();
            if (mapperDatasource.isPresent()) {
                String dataSourceName = mapperDatasource.get().value().asString();
                mappers.produce((BuildItem)new MyBatisMapperBuildItem(dotName, dataSourceName));
                continue;
            }
            mappers.produce((BuildItem)new MyBatisMapperBuildItem(dotName, "<default>"));
        }
    }

    @BuildStep
    void addMyBatisMappedTypes(BuildProducer<MyBatisMappedTypeBuildItem> mappedTypes, BuildProducer<MyBatisMappedJdbcTypeBuildItem> mappedJdbcTypes, CombinedIndexBuildItem indexBuildItem) {
        DotName dotName;
        ArrayList<DotName> names = new ArrayList<DotName>();
        for (AnnotationInstance i : indexBuildItem.getIndex().getAnnotations(MYBATIS_TYPE_HANDLER)) {
            if (i.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            dotName = i.target().asClass().name();
            mappedTypes.produce((BuildItem)new MyBatisMappedTypeBuildItem(dotName));
            names.add(dotName);
        }
        for (AnnotationInstance i : indexBuildItem.getIndex().getAnnotations(MYBATIS_JDBC_TYPE_HANDLER)) {
            if (i.target().kind() != AnnotationTarget.Kind.CLASS || names.contains(dotName = i.target().asClass().name())) continue;
            mappedJdbcTypes.produce((BuildItem)new MyBatisMappedJdbcTypeBuildItem(dotName));
        }
    }

    @BuildStep
    void initialSql(BuildProducer<NativeImageResourceBuildItem> resource, MyBatisRuntimeConfig config) {
        config.initialSql.ifPresent(initialSql -> resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{initialSql})));
        config.dataSources.values().forEach(dataSource -> dataSource.initialSql.ifPresent(initialSql -> resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{initialSql}))));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void generateSqlSessionFactory(MyBatisRuntimeConfig myBatisRuntimeConfig, ConfigurationFactoryBuildItem configurationFactoryBuildItem, SqlSessionFactoryBuilderBuildItem sqlSessionFactoryBuilderBuildItem, List<MyBatisMapperBuildItem> myBatisMapperBuildItems, List<MyBatisMappedTypeBuildItem> myBatisMappedTypeBuildItems, List<MyBatisMappedJdbcTypeBuildItem> myBatisMappedJdbcTypeBuildItems, List<ConfigurationCustomizerBuildItem> configurationCustomizerBuildItems, List<JdbcDataSourceBuildItem> jdbcDataSourcesBuildItem, BuildProducer<SqlSessionFactoryBuildItem> sqlSessionFactory, MyBatisRecorder recorder) {
        List mappedTypes = myBatisMappedTypeBuildItems.stream().map(m -> m.getMappedTypeName().toString()).collect(Collectors.toList());
        List mappedJdbcTypes = myBatisMappedJdbcTypeBuildItems.stream().map(m -> m.getMappedJdbcTypeName().toString()).collect(Collectors.toList());
        List<Object> dataSources = new ArrayList();
        if (myBatisRuntimeConfig.dataSource.isPresent()) {
            String dataSourceName = (String)myBatisRuntimeConfig.dataSource.get();
            Optional<JdbcDataSourceBuildItem> jdbcDataSourceBuildItem = jdbcDataSourcesBuildItem.stream().filter(i -> i.getName().equals(dataSourceName)).findFirst();
            if (jdbcDataSourceBuildItem.isEmpty()) {
                throw new ConfigurationException("Can not find datasource " + dataSourceName);
            }
            dataSources.add(Pair.of((Object)dataSourceName, (Object)true));
        } else {
            dataSources = jdbcDataSourcesBuildItem.stream().map(dataSource -> Pair.of((Object)dataSource.getName(), (Object)dataSource.isDefault())).collect(Collectors.toList());
            if (dataSources.isEmpty()) {
                throw new ConfigurationException("No datasource found");
            }
        }
        List configurationCustomizers = configurationCustomizerBuildItems.stream().map(ConfigurationCustomizerBuildItem::getCustomizer).collect(Collectors.toList());
        dataSources.forEach(dataSource -> {
            MyBatisDataSourceRuntimeConfig dataSourceConfig = (MyBatisDataSourceRuntimeConfig)myBatisRuntimeConfig.dataSources.get(dataSource.getKey());
            List mappers = myBatisMapperBuildItems.stream().filter(m -> m.getDataSourceName().equals(dataSource.getKey())).map(m -> m.getMapperName().toString()).collect(Collectors.toList());
            sqlSessionFactory.produce((BuildItem)new SqlSessionFactoryBuildItem((RuntimeValue<SqlSessionFactory>)recorder.createSqlSessionFactory(configurationFactoryBuildItem.getFactory(), configurationCustomizers, sqlSessionFactoryBuilderBuildItem.getBuilder(), myBatisRuntimeConfig, dataSourceConfig, (String)dataSource.getKey(), mappers, mappedTypes, mappedJdbcTypes), (String)dataSource.getKey(), (Boolean)dataSource.getValue(), false));
        });
    }

    @BuildStep
    @Overridable
    ConfigurationFactoryBuildItem createConfigurationFactory() {
        return new ConfigurationFactoryBuildItem((ConfigurationFactory)new MyBatisConfigurationFactory());
    }

    @BuildStep
    @Overridable
    SqlSessionFactoryBuilderBuildItem createSqlSessionFactoryBuilder() {
        return new SqlSessionFactoryBuilderBuildItem(new SqlSessionFactoryBuilder());
    }

    @BuildStep
    @Overridable
    XMLConfigBuilderBuildItem createXMLConfigBuilder() {
        return new XMLConfigBuilderBuildItem((XMLConfigDelegateBuilder)new MyBatisXMLConfigDelegateBuilder());
    }

    @BuildStep
    void xmlConfig(MyBatisRuntimeConfig config, BuildProducer<MyBatisXmlConfigBuildItem> xmlConfig) {
        if (config.xmlconfig.enable) {
            xmlConfig.produce((BuildItem)new MyBatisXmlConfigBuildItem("xmlconfig", true));
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void generateSqlSessionFactoryFromXmlConfig(MyBatisRuntimeConfig config, XMLConfigBuilderBuildItem xmlConfigBuilderBuildItem, MyBatisXmlConfigBuildItem xmlConfigBuildItem, BuildProducer<SqlSessionFactoryBuildItem> sqlSessionFactory, MyBatisRecorder recorder) {
        if (xmlConfigBuildItem != null && xmlConfigBuildItem.isEnabled()) {
            sqlSessionFactory.produce((BuildItem)new SqlSessionFactoryBuildItem((RuntimeValue<SqlSessionFactory>)recorder.createSqlSessionFactory(config, xmlConfigBuilderBuildItem.getBuilder()), xmlConfigBuildItem.getName(), false, true));
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateSqlSessionManager(List<SqlSessionFactoryBuildItem> sqlSessionFactoryBuildItems, BuildProducer<SqlSessionManagerBuildItem> sqlSessionManager, MyBatisRecorder recorder) {
        sqlSessionFactoryBuildItems.forEach(sessionFactory -> sqlSessionManager.produce((BuildItem)new SqlSessionManagerBuildItem((RuntimeValue<TransactionalSqlSession>)recorder.createSqlSessionManager(sessionFactory.getSqlSessionFactory()), sessionFactory.getDataSourceName(), sessionFactory.isDefaultDataSource())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateMapperBeans(MyBatisRecorder recorder, List<MyBatisMapperBuildItem> myBatisMapperBuildItems, List<MyBatisMappedTypeBuildItem> myBatisMappedTypesBuildItems, List<MyBatisMappedJdbcTypeBuildItem> myBatisMappedJdbcTypesBuildItems, List<SqlSessionManagerBuildItem> sqlSessionManagerBuildItems, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator;
        Map dataSourceToSessionManagerBuildItem = sqlSessionManagerBuildItems.stream().collect(Collectors.toMap(SqlSessionManagerBuildItem::getDataSourceName, Function.identity()));
        SqlSessionManagerBuildItem defaultSqlSessionManagerBuildItem = this.getDefaultSessionManager(sqlSessionManagerBuildItems);
        for (MyBatisMapperBuildItem myBatisMapperBuildItem : myBatisMapperBuildItems) {
            SqlSessionManagerBuildItem sessionManagerBuildItem;
            if (myBatisMapperBuildItem.getDataSourceName() == null) {
                if (!defaultSqlSessionManagerBuildItem.isDefaultDataSource() && sqlSessionManagerBuildItems.size() != 1) throw new ConfigurationException("Could not choose data source for mapper: " + myBatisMapperBuildItem.getMapperName() + ". Please use @MapperDataSource annotation for specified the mapper class");
                sessionManagerBuildItem = defaultSqlSessionManagerBuildItem;
            } else {
                sessionManagerBuildItem = (SqlSessionManagerBuildItem)((Object)dataSourceToSessionManagerBuildItem.get(myBatisMapperBuildItem.getDataSourceName()));
                if (sessionManagerBuildItem == null) {
                    throw new ConfigurationException(String.format("Data source %s does not exist", myBatisMapperBuildItem.getDataSourceName()));
                }
            }
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator2 = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)myBatisMapperBuildItem.getMapperName()).scope(Singleton.class)).setRuntimeInit().unremovable()).supplier(recorder.MyBatisMapperSupplier(myBatisMapperBuildItem.getMapperName().toString(), sessionManagerBuildItem.getSqlSessionManager()));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator2.done());
        }
        for (MyBatisMappedTypeBuildItem myBatisMappedTypeBuildItem : myBatisMappedTypesBuildItems) {
            configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)myBatisMappedTypeBuildItem.getMappedTypeName()).scope(Singleton.class)).setRuntimeInit().unremovable()).supplier(recorder.MyBatisMappedTypeSupplier(myBatisMappedTypeBuildItem.getMappedTypeName().toString(), defaultSqlSessionManagerBuildItem.getSqlSessionManager()));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
        }
        for (MyBatisMappedJdbcTypeBuildItem myBatisMappedJdbcTypeBuildItem : myBatisMappedJdbcTypesBuildItems) {
            configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)myBatisMappedJdbcTypeBuildItem.getMappedJdbcTypeName()).scope(Singleton.class)).setRuntimeInit().unremovable()).supplier(recorder.MyBatisMappedJdbcTypeSupplier(myBatisMappedJdbcTypeBuildItem.getMappedJdbcTypeName().toString(), defaultSqlSessionManagerBuildItem.getSqlSessionManager()));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void register(List<SqlSessionFactoryBuildItem> sqlSessionFactoryBuildItems, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, MyBatisRecorder recorder) {
        sqlSessionFactoryBuildItems.forEach(sqlSessionFactoryBuildItem -> {
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SqlSessionFactory.class).scope(Singleton.class)).unremovable()).supplier(recorder.MyBatisSqlSessionFactorySupplier(sqlSessionFactoryBuildItem.getSqlSessionFactory()));
            String dataSourceName = sqlSessionFactoryBuildItem.getDataSourceName();
            if (!sqlSessionFactoryBuildItem.isDefaultDataSource()) {
                configurator.defaultBean();
                configurator.addQualifier().annotation(Named.class).addValue("value", (Object)dataSourceName).done();
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
        });
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void runInitialSql(List<SqlSessionFactoryBuildItem> sqlSessionFactoryBuildItems, MyBatisRuntimeConfig myBatisRuntimeConfig, MyBatisRecorder recorder) {
        sqlSessionFactoryBuildItems.forEach(sqlSessionFactoryBuildItem -> {
            MyBatisDataSourceRuntimeConfig dataSourceConfig = (MyBatisDataSourceRuntimeConfig)myBatisRuntimeConfig.dataSources.get(sqlSessionFactoryBuildItem.getDataSourceName());
            Optional optionalInitialSql = sqlSessionFactoryBuildItem.isDefaultDataSource() || sqlSessionFactoryBuildItems.size() == 1 ? (dataSourceConfig != null && dataSourceConfig.initialSql.isPresent() ? dataSourceConfig.initialSql : myBatisRuntimeConfig.initialSql) : (dataSourceConfig != null ? dataSourceConfig.initialSql : Optional.empty());
            optionalInitialSql.ifPresent(initialSql -> recorder.runInitialSql(sqlSessionFactoryBuildItem.getSqlSessionFactory(), initialSql));
        });
    }

    private SqlSessionManagerBuildItem getDefaultSessionManager(List<SqlSessionManagerBuildItem> sqlSessionManagerBuildItems) {
        return sqlSessionManagerBuildItems.stream().filter(SqlSessionManagerBuildItem::isDefaultDataSource).findFirst().orElse(sqlSessionManagerBuildItems.get(0));
    }
}

