/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mybatis.runtime;

import io.quarkiverse.mybatis.runtime.MyBatisProducers;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.util.List;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.jboss.logging.Logger;

@Recorder
public class MyBatisRecorder {
    private static final Logger LOG = Logger.getLogger(MyBatisRecorder.class);

    public RuntimeValue<SqlSessionFactory> createSqlSessionFactory(String environment, String transactionFactory, String dataSourceName, String mapUnderscoreToCamelCase, List<String> mappers) {
        Configuration configuration = new Configuration();
        Object factory = transactionFactory.equals("MANAGED") ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
        if ("true".equals(mapUnderscoreToCamelCase)) {
            configuration.setMapUnderscoreToCamelCase(true);
        }
        Environment.Builder environmentBuilder = new Environment.Builder(environment).transactionFactory((TransactionFactory)factory).dataSource((DataSource)DataSources.fromName((String)dataSourceName));
        configuration.setEnvironment(environmentBuilder.build());
        for (String mapper : mappers) {
            try {
                configuration.addMapper(Resources.classForName((String)mapper));
            }
            catch (ClassNotFoundException e) {
                LOG.debug((Object)("Can not find the mapper class " + mapper));
            }
        }
        SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
        return new RuntimeValue((Object)sqlSessionFactory);
    }

    public RuntimeValue<SqlSessionManager> createSqlSessionManager(RuntimeValue<SqlSessionFactory> sqlSessionFactory) {
        SqlSessionManager sqlSessionManager = SqlSessionManager.newInstance((SqlSessionFactory)((SqlSessionFactory)sqlSessionFactory.getValue()));
        return new RuntimeValue((Object)sqlSessionManager);
    }

    public Supplier<Object> MyBatisMapperSupplier(String name, RuntimeValue<SqlSessionManager> sqlSessionManager) {
        return () -> {
            try {
                return ((SqlSessionManager)sqlSessionManager.getValue()).getMapper(Resources.classForName((String)name));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        };
    }

    public void runInitialSql(RuntimeValue<SqlSessionFactory> sqlSessionFactory, String sql) {
        try (SqlSession session = ((SqlSessionFactory)sqlSessionFactory.getValue()).openSession();){
            Connection conn = session.getConnection();
            Reader reader = Resources.getResourceAsReader((String)sql);
            ScriptRunner runner = new ScriptRunner(conn);
            runner.setLogWriter(null);
            runner.runScript(reader);
            reader.close();
        }
        catch (Exception e) {
            LOG.warn((Object)("Error executing SQL Script " + sql));
        }
    }

    public void register(RuntimeValue<SqlSessionFactory> sqlSessionFactory, BeanContainer beanContainer) {
        ((MyBatisProducers)beanContainer.instance(MyBatisProducers.class, new Annotation[0])).setSqlSessionFactory((SqlSessionFactory)sqlSessionFactory.getValue());
    }
}

