/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mybatis.runtime;

import jakarta.transaction.Synchronization;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class TransactionalSqlSession
implements SqlSession {
    private final SqlSessionFactory sqlSessionFactory;
    private final TransactionManager transactionManager;
    private final SqlSession sqlSessionProxy;

    public TransactionalSqlSession(SqlSessionFactory sqlSessionFactory, TransactionManager transactionManager) {
        this.sqlSessionFactory = sqlSessionFactory;
        this.transactionManager = transactionManager;
        this.sqlSessionProxy = (SqlSession)Proxy.newProxyInstance(SqlSession.class.getClassLoader(), new Class[]{SqlSession.class}, (InvocationHandler)new TransactionalSqlSessionInterceptor());
    }

    public <T> T selectOne(String statement) {
        return (T)this.sqlSessionProxy.selectOne(statement);
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.sqlSessionProxy.selectOne(statement, parameter);
    }

    public <E> List<E> selectList(String statement) {
        return this.sqlSessionProxy.selectList(statement);
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.sqlSessionProxy.selectList(statement, parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.sqlSessionProxy.selectList(statement, parameter, rowBounds);
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        return this.sqlSessionProxy.selectMap(statement, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.sqlSessionProxy.selectMap(statement, parameter, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        return this.sqlSessionProxy.selectMap(statement, parameter, mapKey, rowBounds);
    }

    public <T> Cursor<T> selectCursor(String statement) {
        return this.sqlSessionProxy.selectCursor(statement);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter) {
        return this.sqlSessionProxy.selectCursor(statement, parameter);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter, RowBounds rowBounds) {
        return this.sqlSessionProxy.selectCursor(statement, parameter, rowBounds);
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.sqlSessionProxy.select(statement, parameter, handler);
    }

    public void select(String statement, ResultHandler handler) {
        this.sqlSessionProxy.select(statement, handler);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.sqlSessionProxy.select(statement, parameter, rowBounds, handler);
    }

    public int insert(String statement) {
        return this.sqlSessionProxy.insert(statement);
    }

    public int insert(String statement, Object parameter) {
        return this.sqlSessionProxy.insert(statement, parameter);
    }

    public int update(String statement) {
        return this.sqlSessionProxy.update(statement);
    }

    public int update(String statement, Object parameter) {
        return this.sqlSessionProxy.update(statement, parameter);
    }

    public int delete(String statement) {
        return this.sqlSessionProxy.delete(statement);
    }

    public int delete(String statement, Object parameter) {
        return this.sqlSessionProxy.delete(statement, parameter);
    }

    public void commit() {
        throw new UnsupportedOperationException("Manual close is not allowed over a Transactional SqlSession");
    }

    public void commit(boolean force) {
        throw new UnsupportedOperationException("Manual close is not allowed over a Transactional SqlSession");
    }

    public void rollback() {
        throw new UnsupportedOperationException("Manual close is not allowed over a Transactional SqlSession");
    }

    public void rollback(boolean force) {
        throw new UnsupportedOperationException("Manual close is not allowed over a Transactional SqlSession");
    }

    public List<BatchResult> flushStatements() {
        return this.sqlSessionProxy.flushStatements();
    }

    public void close() {
        throw new UnsupportedOperationException("Manual close is not allowed over a Transactional SqlSession");
    }

    public void clearCache() {
        this.sqlSessionProxy.clearCache();
    }

    public Configuration getConfiguration() {
        return this.sqlSessionFactory.getConfiguration();
    }

    public <T> T getMapper(Class<T> type) {
        return (T)this.getConfiguration().getMapper(type, (SqlSession)this);
    }

    public Connection getConnection() {
        return this.sqlSessionProxy.getConnection();
    }

    private class TransactionalSqlSessionInterceptor
    implements InvocationHandler {
        private final Map<Transaction, SqlSession> sqlSessionMap = new ConcurrentHashMap<Transaction, SqlSession>();

        private TransactionalSqlSessionInterceptor() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            SqlSession sqlSession = null;
            try {
                sqlSession = this.getSqlSession();
                Object result = method.invoke((Object)sqlSession, args);
                sqlSession.commit();
                Object object = result;
                return object;
            }
            catch (Throwable t) {
                sqlSession.rollback();
                throw ExceptionUtil.unwrapThrowable((Throwable)t);
            }
            finally {
                if (!this.isTransactionActive() && sqlSession != null) {
                    sqlSession.close();
                }
            }
        }

        private SqlSession getSqlSession() throws Exception {
            if (this.isTransactionActive()) {
                SqlSession sqlSession = this.sqlSessionMap.computeIfAbsent(TransactionalSqlSession.this.transactionManager.getTransaction(), transaction -> {
                    final SqlSession session = TransactionalSqlSession.this.sqlSessionFactory.openSession();
                    try {
                        transaction.registerSynchronization(new Synchronization(){
                            final /* synthetic */ Transaction val$transaction;
                            {
                                this.val$transaction = transaction;
                            }

                            public void beforeCompletion() {
                                session.close();
                                TransactionalSqlSessionInterceptor.this.sqlSessionMap.remove(this.val$transaction);
                            }

                            public void afterCompletion(int status) {
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Session " + session + " can not register synchronization in transaction ", e);
                    }
                    return session;
                });
                return sqlSession;
            }
            return TransactionalSqlSession.this.sqlSessionFactory.openSession();
        }

        private boolean isTransactionActive() {
            try {
                if (TransactionalSqlSession.this.transactionManager == null) {
                    return false;
                }
                Transaction tx = TransactionalSqlSession.this.transactionManager.getTransaction();
                return tx != null && (tx.getStatus() == 0 || tx.getStatus() == 1);
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

