/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.deployment;

import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.neo4j.deployment.Neo4jBuildTimeConfig;
import io.quarkus.neo4j.deployment.Neo4jDevServicesProcessor;
import java.util.List;

class Neo4jDevUiConsoleProcessor {
    Neo4jDevUiConsoleProcessor() {
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    CardPageBuildItem create(List<DevServicesResultBuildItem> runningDevServices, Neo4jBuildTimeConfig neo4jBuildTimeConfig) {
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        if (Neo4jDevServicesProcessor.enabled(neo4jBuildTimeConfig.devservices)) {
            for (DevServicesResultBuildItem runningDevService : runningDevServices) {
                if (!runningDevService.getConfig().containsKey("quarkus.neo4j.browser-url")) continue;
                cardPageBuildItem.addPage((PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Neo4J Browser").icon("font-awesome-solid:diagram-project")).url((String)runningDevService.getConfig().get("quarkus.neo4j.browser-url")).doNotEmbed());
                break;
            }
        }
        return cardPageBuildItem;
    }
}

