/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedPackageBuildItem;
import io.quarkus.deployment.metrics.MetricsFactoryConsumerBuildItem;
import io.quarkus.neo4j.deployment.Neo4jBuildTimeConfig;
import io.quarkus.neo4j.deployment.Neo4jDriverBuildItem;
import io.quarkus.neo4j.runtime.Neo4jConfiguration;
import io.quarkus.neo4j.runtime.Neo4jDriverRecorder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.function.Consumer;
import org.neo4j.driver.Driver;

class Neo4jDriverProcessor {
    Neo4jDriverProcessor() {
    }

    @BuildStep
    FeatureBuildItem createFeature(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport) {
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.NEO4J));
        return new FeatureBuildItem(Feature.NEO4J);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    Neo4jDriverBuildItem configureDriverProducer(Neo4jDriverRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, Neo4jConfiguration configuration, ShutdownContextBuildItem shutdownContext) {
        RuntimeValue driverHolder = recorder.initializeDriver(configuration, (ShutdownContext)shutdownContext);
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(Driver.class).runtimeValue(driverHolder).setRuntimeInit().done());
        return new Neo4jDriverBuildItem((RuntimeValue<Driver>)driverHolder);
    }

    @BuildStep
    HealthBuildItem addHealthCheck(Neo4jBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkus.neo4j.runtime.health.Neo4jHealthCheck", buildTimeConfig.healthEnabled);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void metrics(Neo4jConfiguration configuration, Neo4jDriverRecorder recorder, BuildProducer<MetricsFactoryConsumerBuildItem> metrics) {
        Consumer metricsFactoryConsumer = recorder.registerMetrics(configuration);
        metrics.produce((BuildItem)new MetricsFactoryConsumerBuildItem(metricsFactoryConsumer));
    }

    @BuildStep
    RuntimeInitializedPackageBuildItem deferNettySSLToRuntime() {
        return new RuntimeInitializedPackageBuildItem("io.netty.handler.ssl");
    }

    @BuildStep
    void deferMiscellaneousClassesToRuntime(BuildProducer<RuntimeInitializedClassBuildItem> classes) {
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.buffer.AbstractReferenceCountedByteBuf"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.buffer.ByteBufAllocator"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.buffer.ByteBufUtil"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.buffer.ByteBufUtil$HexUtil"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.buffer.PooledByteBufAllocator"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.buffer.UnpooledHeapByteBuf"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.buffer.UnreleasableByteBuf"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("org.neo4j.driver.internal.async.connection.BoltProtocolUtil"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("org.neo4j.driver.internal.async.connection.ChannelAttributes"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("org.neo4j.driver.internal.async.connection.ChannelConnectedListener"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.util.AbstractReferenceCounted"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.util.internal.logging.Log4JLogger"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.internal.tcnative.SSL"));
        classes.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.core.net.impl.SSLHelper"));
    }
}

