/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.deployment;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServiceDescriptionBuildItem;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.neo4j.deployment.BoltHandshaker;
import io.quarkus.neo4j.deployment.DevServicesBuildTimeConfig;
import io.quarkus.neo4j.deployment.Neo4jBuildTimeConfig;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.Neo4jContainer;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

class Neo4jDevServicesProcessor {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.neo4j.deployment");
    private static final String NEO4J_URI = "quarkus.neo4j.uri";
    static final String NEO4J_BROWSER_URL = "quarkus.neo4j.browser-url";
    private static final String NEO4J_USER_PROP = "quarkus.neo4j.authentication.username";
    private static final String NEO4J_PASSWORD_PROP = "quarkus.neo4j.authentication.password";
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile Neo4jDevServiceConfig runningConfiguration;
    static volatile boolean first;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    Neo4jDevServicesProcessor() {
    }

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public DevServicesResultBuildItem startNeo4jDevService(LaunchModeBuildItem launchMode, Neo4jBuildTimeConfig neo4jBuildTimeConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig globalDevServicesConfig) {
        Neo4jDevServiceConfig configuration = new Neo4jDevServiceConfig(neo4jBuildTimeConfig.devservices);
        if (devService != null) {
            if (configuration.equals(runningConfiguration)) {
                return devService.toBuildItem();
            }
            this.shutdownNeo4j();
            runningConfiguration = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Neo4j Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            ExtNeo4jContainer neo4jContainer = this.startNeo4j(configuration, globalDevServicesConfig.timeout);
            if (neo4jContainer != null) {
                Map<String, String> config = Map.of(NEO4J_URI, neo4jContainer.getBoltUrl(), NEO4J_BROWSER_URL, neo4jContainer.getBrowserUrl(), NEO4J_PASSWORD_PROP, neo4jContainer.getAdminPassword());
                log.infof("Dev Services started a Neo4j container reachable at %s", (Object)neo4jContainer.getBoltUrl());
                log.infof("Neo4j Browser is reachable at %s", (Object)neo4jContainer.getBrowserUrl());
                log.infof("The username for both endpoints is `%s`, authenticated by `%s`", (Object)"neo4j", (Object)neo4jContainer.getAdminPassword());
                log.infof("Connect via Cypher-Shell: cypher-shell -u %s -p %s -a %s", (Object)"neo4j", (Object)neo4jContainer.getAdminPassword(), (Object)neo4jContainer.getBoltUrl());
                devService = new DevServicesResultBuildItem.RunningDevService(Feature.NEO4J.getName(), neo4jContainer.getContainerId(), () -> ((ExtNeo4jContainer)neo4jContainer).close(), config);
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownNeo4j();
                    log.info((Object)"Dev Services for Neo4j shut down.");
                }
                first = true;
                runningConfiguration = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        runningConfiguration = configuration;
        return devService == null ? null : devService.toBuildItem();
    }

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    @Consume(value=DevServicesResultBuildItem.class)
    DevServiceDescriptionBuildItem renderDevServiceDevUICard() {
        return devService == null ? null : new DevServiceDescriptionBuildItem(Feature.NEO4J.getName(), null, devService.getConfig());
    }

    private ExtNeo4jContainer startNeo4j(Neo4jDevServiceConfig configuration, Optional<Duration> timeout) {
        boolean boldIsReachable;
        if (!this.isDockerWorking.getAsBoolean()) {
            log.debug((Object)"Not starting Dev Services for Neo4j, as Docker is not working.");
            return null;
        }
        if (!configuration.devServicesEnabled) {
            log.debug((Object)"Not starting Dev Services for Neo4j, as it has been disabled in the config.");
            return null;
        }
        if (ConfigUtils.isPropertyPresent((String)NEO4J_URI) || ConfigUtils.isPropertyPresent((String)NEO4J_USER_PROP) || ConfigUtils.isPropertyPresent((String)NEO4J_PASSWORD_PROP)) {
            log.debug((Object)"Not starting Dev Services for Neo4j, as there is explicit configuration present.");
            return null;
        }
        boolean bl = boldIsReachable = Boolean.getBoolean("io.quarkus.neo4j.deployment.devservices.assumeBoltIsReachable") || new BoltHandshaker("localhost", 7687).isBoltPortReachable(Duration.ofSeconds(5L));
        if (boldIsReachable) {
            log.warn((Object)"Not starting Dev Services for Neo4j, as the default config points to a reachable address. Be aware that your local database will be used.");
            return null;
        }
        ExtNeo4jContainer neo4jContainer = ExtNeo4jContainer.of(configuration);
        configuration.additionalEnv.forEach((arg_0, arg_1) -> ((ExtNeo4jContainer)neo4jContainer).addEnv(arg_0, arg_1));
        timeout.ifPresent(arg_0 -> ((ExtNeo4jContainer)neo4jContainer).withStartupTimeout(arg_0));
        neo4jContainer.start();
        return neo4jContainer;
    }

    private void shutdownNeo4j() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop Neo4j container", e);
            }
            finally {
                devService = null;
            }
        }
    }

    static boolean enabled(DevServicesBuildTimeConfig devServicesConfig) {
        return Optional.ofNullable(devServicesConfig).flatMap(cfg -> cfg.enabled).orElse(true);
    }

    static {
        first = true;
    }

    private static final class Neo4jDevServiceConfig {
        final boolean devServicesEnabled;
        final String imageName;
        final Map<String, String> additionalEnv;
        final OptionalInt fixedBoltPort;
        final OptionalInt fixedHttpPort;

        Neo4jDevServiceConfig(DevServicesBuildTimeConfig devServicesConfig) {
            this.devServicesEnabled = Neo4jDevServicesProcessor.enabled(devServicesConfig);
            this.imageName = devServicesConfig.imageName;
            this.additionalEnv = new HashMap<String, String>(devServicesConfig.additionalEnv);
            this.fixedBoltPort = devServicesConfig.boltPort;
            this.fixedHttpPort = devServicesConfig.httpPort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Neo4jDevServiceConfig that = (Neo4jDevServiceConfig)o;
            return this.devServicesEnabled == that.devServicesEnabled && this.imageName.equals(that.imageName) && this.additionalEnv.equals(that.additionalEnv) && this.fixedBoltPort.equals(that.fixedBoltPort) && this.fixedHttpPort.equals(that.fixedHttpPort);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.additionalEnv, this.fixedBoltPort, this.fixedHttpPort);
        }
    }

    private static final class ExtNeo4jContainer
    extends Neo4jContainer<ExtNeo4jContainer> {
        private static final int DEFAULT_HTTP_PORT = 7474;
        private static final int DEFAULT_BOLT_PORT = 7687;

        static ExtNeo4jContainer of(Neo4jDevServiceConfig config) {
            ExtNeo4jContainer container = new ExtNeo4jContainer(DockerImageName.parse((String)config.imageName).asCompatibleSubstituteFor("neo4j"));
            config.fixedBoltPort.ifPresent(port -> container.addFixedExposedPort(port, 7687));
            config.fixedHttpPort.ifPresent(port -> container.addFixedExposedPort(port, 7474));
            String extensionScript = "/neo4j_dev_services_ext.sh";
            return (ExtNeo4jContainer)((ExtNeo4jContainer)container.withCopyFileToContainer(MountableFile.forClasspathResource((String)("/io/quarkus/neo4j/deployment" + extensionScript), (Integer)511), extensionScript)).withEnv("EXTENSION_SCRIPT", extensionScript);
        }

        ExtNeo4jContainer(DockerImageName dockerImageName) {
            super(dockerImageName);
        }

        String getBrowserUrl() {
            return String.format("%s/browser?dbms=bolt://%s@%s:%d", this.getHttpUrl(), "neo4j", this.getHost(), this.getMappedPort(7687));
        }

        protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
            super.containerIsStarting(containerInfo, reused);
            if (reused) {
                return;
            }
            Integer mappedPort = this.getMappedPort(7687);
            String command = String.format("export NEO4J_dbms_connector_bolt_advertised__address=%s:%d\n", this.getHost(), mappedPort);
            this.copyFileToContainer(Transferable.of((byte[])command.getBytes(StandardCharsets.UTF_8)), "/testcontainers_env");
        }
    }
}

