/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.runtime.health;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;
import org.jboss.logging.Logger;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.internal.retry.ExponentialBackoffRetryLogic;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.ServerInfo;

@Readiness
@ApplicationScoped
public class Neo4jHealthCheck
implements HealthCheck {
    private static final Logger log = Logger.getLogger(Neo4jHealthCheck.class);
    private static final String CYPHER = "CALL dbms.components() YIELD versions, name, edition WHERE name = 'Neo4j Kernel' RETURN edition, versions[0] as version";
    private static final String MESSAGE_HEALTH_CHECK_FAILED = "Neo4j health check failed";
    private static final String MESSAGE_SESSION_EXPIRED = "Neo4j session has expired, retrying one single time to retrieve server health.";
    private static final SessionConfig DEFAULT_SESSION_CONFIG = SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE).build();
    @Inject
    Driver driver;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Neo4j connection health check").up();
        try {
            try {
                return this.runHealthCheckQuery(builder);
            }
            catch (Throwable exception) {
                if (ExponentialBackoffRetryLogic.isRetryable((Throwable)exception)) {
                    log.warn((Object)MESSAGE_SESSION_EXPIRED);
                    return this.runHealthCheckQuery(builder);
                }
                throw exception;
            }
        }
        catch (Exception e) {
            return builder.down().withData("reason", e.getMessage()).build();
        }
    }

    private static HealthCheckResponse buildStatusUp(Record editionAndVersion, ResultSummary resultSummary, HealthCheckResponseBuilder builder) {
        ServerInfo serverInfo = resultSummary.server();
        builder.withData("server", "Neo4j/" + editionAndVersion.get("version").asString() + "@" + serverInfo.address());
        String databaseName = resultSummary.database().name();
        if (databaseName != null && !databaseName.trim().isEmpty()) {
            builder.withData("database", databaseName.trim());
        }
        builder.withData("edition", editionAndVersion.get("edition").asString());
        return builder.build();
    }

    private HealthCheckResponse runHealthCheckQuery(HealthCheckResponseBuilder builder) {
        try (Session session = this.driver.session(DEFAULT_SESSION_CONFIG);){
            Result result = session.run(CYPHER);
            Record editionAndVersion = result.single();
            ResultSummary resultSummary = result.consume();
            HealthCheckResponse healthCheckResponse = Neo4jHealthCheck.buildStatusUp(editionAndVersion, resultSummary, builder);
            return healthCheckResponse;
        }
    }
}

