/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.runtime;

import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import org.neo4j.driver.Config;

@ConfigMapping(prefix="quarkus.neo4j")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface Neo4jConfiguration {
    public static final String DEFAULT_SERVER_URI = "bolt://localhost:7687";
    public static final String DEFAULT_USERNAME = "neo4j";
    public static final String DEFAULT_PASSWORD = "neo4j";

    @WithDefault(value="bolt://localhost:7687")
    public String uri();

    @ConfigDocSection
    public Authentication authentication();

    @WithDefault(value="false")
    public boolean encrypted();

    @ConfigDocSection
    public TrustSettings trustSettings();

    @WithDefault(value="30S")
    public Duration maxTransactionRetryTime();

    @ConfigDocSection
    public Pool pool();

    @ConfigGroup
    public static interface Pool {
        @WithName(value="metrics.enabled")
        @WithDefault(value="false")
        public boolean metricsEnabled();

        @WithDefault(value="false")
        public boolean logLeakedSessions();

        @WithDefault(value="100")
        public int maxConnectionPoolSize();

        @WithDefault(value="-0.001S")
        public Duration idleTimeBeforeConnectionTest();

        @WithDefault(value="1H")
        public Duration maxConnectionLifetime();

        @WithDefault(value="1M")
        public Duration connectionAcquisitionTimeout();
    }

    @ConfigGroup
    public static interface TrustSettings {
        @WithDefault(value="TRUST_SYSTEM_CA_SIGNED_CERTIFICATES")
        public Strategy strategy();

        public Optional<Path> certFile();

        @WithDefault(value="false")
        public boolean hostnameVerificationEnabled();

        default public Config.TrustStrategy toInternalRepresentation() {
            Strategy nonNullStrategy = this.strategy() == null ? Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES : this.strategy();
            Config.TrustStrategy internalRepresentation = switch (nonNullStrategy) {
                default -> throw new IncompatibleClassChangeError();
                case Strategy.TRUST_ALL_CERTIFICATES -> Config.TrustStrategy.trustAllCertificates();
                case Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES -> Config.TrustStrategy.trustSystemCertificates();
                case Strategy.TRUST_CUSTOM_CA_SIGNED_CERTIFICATES -> {
                    File certFile = this.certFile().map(Path::toFile).filter(File::isFile).orElseThrow(() -> new RuntimeException("Configured trust strategy requires a certificate file."));
                    yield Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{certFile});
                }
            };
            if (this.hostnameVerificationEnabled()) {
                internalRepresentation.withHostnameVerification();
            } else {
                internalRepresentation.withoutHostnameVerification();
            }
            return internalRepresentation;
        }

        public static enum Strategy {
            TRUST_ALL_CERTIFICATES,
            TRUST_CUSTOM_CA_SIGNED_CERTIFICATES,
            TRUST_SYSTEM_CA_SIGNED_CERTIFICATES;

        }
    }

    @ConfigGroup
    public static interface Authentication {
        @WithDefault(value="neo4j")
        public String username();

        @WithDefault(value="neo4j")
        public String password();

        @WithDefault(value="false")
        public boolean disabled();

        public Optional<String> value();
    }
}

