/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.runtime;

import io.quarkus.bootstrap.graal.ImageInfo;
import io.quarkus.neo4j.runtime.Neo4jConfiguration;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.metrics.MetricsFactory;
import io.quarkus.runtime.ssl.SslContextConfiguration;
import java.net.URI;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.internal.Scheme;
import org.neo4j.driver.observation.ObservationProvider;
import org.neo4j.driver.observation.metrics.ConnectionPoolMetrics;
import org.neo4j.driver.observation.metrics.Metrics;
import org.neo4j.driver.observation.metrics.MetricsObservationProvider;

@Recorder
public class Neo4jDriverRecorder {
    private static final Logger log = Logger.getLogger(Neo4jDriverRecorder.class);
    private static final boolean HAS_DRIVER_METRICS;
    private final RuntimeValue<Neo4jConfiguration> configuration;

    public Neo4jDriverRecorder(RuntimeValue<Neo4jConfiguration> configuration) {
        this.configuration = configuration;
    }

    public RuntimeValue<Config> buildConfig() {
        Config.ConfigBuilder configBuilder = Neo4jDriverRecorder.createBaseConfig();
        Neo4jDriverRecorder.configureSsl(configBuilder, (Neo4jConfiguration)this.configuration.getValue());
        Neo4jDriverRecorder.configurePoolSettings(configBuilder, ((Neo4jConfiguration)this.configuration.getValue()).pool());
        configBuilder.withMaxTransactionRetryTime(((Neo4jConfiguration)this.configuration.getValue()).maxTransactionRetryTime().toMillis(), TimeUnit.MILLISECONDS);
        return new RuntimeValue((Object)configBuilder.build());
    }

    public RuntimeValue<Driver> initializeDriver(ShutdownContext shutdownContext, RuntimeValue<Config> config) {
        String uri = ((Neo4jConfiguration)this.configuration.getValue()).uri();
        AuthToken authToken = Neo4jDriverRecorder.getAuthToken((Neo4jConfiguration)this.configuration.getValue());
        Driver driver = GraphDatabase.driver((String)uri, (AuthToken)authToken, (Config)((Config)config.getValue()));
        shutdownContext.addShutdownTask(() -> ((Driver)driver).close());
        return new RuntimeValue((Object)driver);
    }

    static AuthToken getAuthToken(Neo4jConfiguration configuration) {
        if (configuration.authentication().disabled()) {
            return AuthTokens.none();
        }
        return configuration.authentication().value().map(Neo4jDriverRecorder::toAuthToken).orElseGet(() -> AuthTokens.basic((String)configuration.authentication().username(), (String)configuration.authentication().password()));
    }

    static AuthToken toAuthToken(String value) {
        int idx = value.indexOf("/");
        if (idx < 1 || idx == value.length() - 1) {
            throw new IllegalArgumentException("Invalid value for NEO4J_AUTH, the only supported format is <username>/<password>, neither username nor password are optional");
        }
        return AuthTokens.basic((String)value.substring(0, idx), (String)value.substring(idx + 1));
    }

    public Consumer<MetricsFactory> registerMetrics(RuntimeValue<Config> config) {
        if (!HAS_DRIVER_METRICS) {
            return metricsFactory -> {};
        }
        return ((Config)config.getValue()).observationProvider().filter(MetricsObservationProvider.class::isInstance).map(MetricsObservationProvider.class::cast).map(MetricsObservationProvider::metrics).map(Metrics::connectionPoolMetrics).map(driverMetrics -> metricsFactory -> {
            Optional connectionPoolMetrics = driverMetrics.stream().findFirst();
            metricsFactory.builder("neo4j.acquired").buildCounter(() -> connectionPoolMetrics.map(ConnectionPoolMetrics::acquired).orElse(0L));
            metricsFactory.builder("neo4j.acquiring").buildCounter(() -> connectionPoolMetrics.map(ConnectionPoolMetrics::acquiring).orElse(0));
            metricsFactory.builder("neo4j.closed").buildCounter(() -> connectionPoolMetrics.map(ConnectionPoolMetrics::closed).orElse(0L));
            metricsFactory.builder("neo4j.created").buildCounter(() -> connectionPoolMetrics.map(ConnectionPoolMetrics::created).orElse(0L));
            metricsFactory.builder("neo4j.creating").buildCounter(() -> connectionPoolMetrics.map(ConnectionPoolMetrics::creating).orElse(0));
            metricsFactory.builder("neo4j.failedToCreate").buildCounter(() -> connectionPoolMetrics.map(ConnectionPoolMetrics::failedToCreate).orElse(0L));
            metricsFactory.builder("neo4j.timedOutToAcquire").buildCounter(() -> connectionPoolMetrics.map(ConnectionPoolMetrics::timedOutToAcquire).orElse(0L));
            metricsFactory.builder("neo4j.totalAcquisitionTime").buildCounter(() -> connectionPoolMetrics.map(ConnectionPoolMetrics::totalAcquisitionTime).orElse(0L));
            metricsFactory.builder("neo4j.totalConnectionTime").buildCounter(() -> connectionPoolMetrics.map(ConnectionPoolMetrics::totalConnectionTime).orElse(0L));
            metricsFactory.builder("neo4j.totalInUseCount").buildCounter(() -> connectionPoolMetrics.map(ConnectionPoolMetrics::totalInUseCount).orElse(0L));
            metricsFactory.builder("neo4j.totalInUseTime").buildCounter(() -> connectionPoolMetrics.map(ConnectionPoolMetrics::totalInUseCount).orElse(0L));
        }).orElseGet(() -> metricsFactory -> {});
    }

    private static Config.ConfigBuilder createBaseConfig() {
        return Config.builder();
    }

    private static void configureSsl(Config.ConfigBuilder configBuilder, Neo4jConfiguration configuration) {
        boolean isNativeWithoutSslSupport;
        URI uri = URI.create(configuration.uri());
        String scheme = uri.getScheme();
        boolean isSecurityScheme = Scheme.isSecurityScheme((String)scheme);
        boolean bl = isNativeWithoutSslSupport = ImageInfo.inImageRuntimeCode() && !SslContextConfiguration.isSslNativeEnabled();
        if (isSecurityScheme) {
            if (isNativeWithoutSslSupport) {
                throw new ConfigurationException("You cannot use " + scheme + " because SSL support is not available in your current native image setup.", Set.of("quarkus.neo4j.uri"));
            }
            return;
        }
        if (isNativeWithoutSslSupport) {
            log.warn((Object)"Native SSL is disabled, communication between this client and the Neo4j server cannot be encrypted.");
            configBuilder.withoutEncryption();
        } else if (configuration.encrypted()) {
            configBuilder.withEncryption();
            configBuilder.withTrustStrategy(configuration.trustSettings().toInternalRepresentation());
        } else {
            configBuilder.withoutEncryption();
        }
    }

    private static void configurePoolSettings(Config.ConfigBuilder configBuilder, Neo4jConfiguration.Pool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuring Neo4j pool settings with " + String.valueOf(pool)));
        }
        if (pool.logLeakedSessions()) {
            configBuilder.withLeakedSessionsLogging();
        }
        configBuilder.withMaxConnectionPoolSize(pool.maxConnectionPoolSize());
        configBuilder.withConnectionLivenessCheckTimeout(pool.idleTimeBeforeConnectionTest().toMillis(), TimeUnit.MILLISECONDS);
        configBuilder.withMaxConnectionLifetime(pool.maxConnectionLifetime().toMillis(), TimeUnit.MILLISECONDS);
        configBuilder.withConnectionAcquisitionTimeout(pool.connectionAcquisitionTimeout().toMillis(), TimeUnit.MILLISECONDS);
        if (pool.metricsEnabled()) {
            if (!HAS_DRIVER_METRICS) {
                log.warn((Object)"Driver metrics enabled, but module org.neo4j.driver:neo4j-java-driver-observation-metrics not provided");
            } else {
                configBuilder.withObservationProvider((ObservationProvider)MetricsObservationProvider.newInstance());
            }
        }
    }

    static {
        boolean metricsObservationProviderFound = true;
        try {
            Class.forName("org.neo4j.driver.observation.metrics.MetricsObservationProvider", false, Neo4jDriverRecorder.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            metricsObservationProviderFound = false;
        }
        HAS_DRIVER_METRICS = metricsObservationProviderFound;
    }
}

