/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.omnifaces.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.ContextRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CustomScopeBuildItem;
import io.quarkus.arc.deployment.KnownCompatibleBeanArchiveBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.omnifaces.runtime.OmniFacesFeature;
import io.quarkus.omnifaces.runtime.OmniFacesRecorder;
import io.quarkus.omnifaces.runtime.scopes.OmniFacesQuarkusViewScope;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.omnifaces.cdi.ContextParam;
import org.omnifaces.cdi.Cookie;
import org.omnifaces.cdi.Eager;
import org.omnifaces.cdi.GraphicImageBean;
import org.omnifaces.cdi.Param;
import org.omnifaces.cdi.PostScriptParam;
import org.omnifaces.cdi.Push;
import org.omnifaces.cdi.Startup;
import org.omnifaces.cdi.ViewScoped;
import org.omnifaces.cdi.converter.ConverterManager;
import org.omnifaces.cdi.eager.EagerBeansRepository;
import org.omnifaces.cdi.validator.ValidatorManager;
import org.omnifaces.cdi.viewscope.ViewScopeManager;
import org.omnifaces.resourcehandler.WebAppManifest;

class OmnifacesProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)"OmnifacesProcessor");
    private static final String FEATURE = "omnifaces";
    static final DotName OMNIFACES_STARTUP = DotName.createSimple((String)Startup.class.getName());
    static final DotName OMNIFACES_EAGER = DotName.createSimple((String)Eager.class.getName());
    private static final Class[] BEAN_CLASSES = new Class[]{EagerBeansRepository.class, ValidatorManager.class, ViewScopeManager.class, ConverterManager.class};
    private static final String[] BEAN_DEFINING_ANNOTATION_CLASSES = new String[]{ContextParam.class.getName(), Cookie.class.getName(), Eager.class.getName(), GraphicImageBean.class.getName(), Param.class.getName(), PostScriptParam.class.getName(), Push.class.getName(), Startup.class.getName()};

    OmnifacesProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageFeatureBuildItem nativeImageFeature() {
        return new NativeImageFeatureBuildItem(OmniFacesFeature.class);
    }

    @BuildStep
    void buildCdiBeans(BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotation) {
        for (Class clazz : BEAN_CLASSES) {
            additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((Class)clazz));
        }
        for (String string : BEAN_DEFINING_ANNOTATION_CLASSES) {
            beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(DotName.createSimple((String)string)));
        }
    }

    @BuildStep
    ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem registerViewScopeContext(ContextRegistrationPhaseBuildItem phase) {
        return new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{phase.getContext().configure(ViewScoped.class).normal().contextClass(OmniFacesQuarkusViewScope.class)});
    }

    @BuildStep
    CustomScopeBuildItem viewScoped() {
        return new CustomScopeBuildItem(DotName.createSimple((String)ViewScoped.class.getName()));
    }

    @BuildStep
    void produceApplicationArchiveMarker(BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> additionalArchiveMarkers) {
        additionalArchiveMarkers.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem("org/omnifaces/component"));
    }

    @BuildStep
    void produceNativeResources(BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer) {
        nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/maven/org.omnifaces/omnifaces/pom.properties"}));
    }

    @BuildStep
    void produceKnownCompatible(BuildProducer<KnownCompatibleBeanArchiveBuildItem> knownCompatibleProducer) {
        knownCompatibleProducer.produce((BuildItem)new KnownCompatibleBeanArchiveBuildItem("org.omnifaces", FEATURE));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildAnnotationProviderIntegration(OmniFacesRecorder recorder, CombinedIndexBuildItem combinedIndex) {
        for (String clazz : BEAN_DEFINING_ANNOTATION_CLASSES) {
            combinedIndex.getIndex().getAnnotations(DotName.createSimple((String)clazz)).forEach(annotation -> {
                if (annotation.target().kind() == AnnotationTarget.Kind.CLASS) {
                    recorder.registerAnnotatedClass(annotation.name().toString(), annotation.target().asClass().name().toString());
                }
            });
        }
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.addAll(this.collectClassesInPackage(combinedIndex, "org.omnifaces.el.functions"));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, "org.omnifaces.util"));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classNames.toArray(new String[0])).methods(true).build());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void registerWebManifests(OmniFacesRecorder recorder, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{WebAppManifest.class}));
    }

    @BuildStep
    void substrateResourceBuildItems(BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundleBuildItem) {
        nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/omnifaces-functions.taglib.xml", "META-INF/omnifaces-ui.taglib.xml", "META-INF/web-fragment.xml", "META-INF/faces-config.xml", "META-INF/web.xml", "org/omnifaces/messages.properties", "META-INF/rsc/myfaces-dev-error-include.xml", "META-INF/services/jakarta.servlet.ServletContainerInitializer", "META-INF/maven/org.omnifaces/omnifaces/pom.properties"}));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.omnifaces.messages"));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void buildDevelopmentInitParams(BuildProducer<ServletInitParamBuildItem> initParam) {
        initParam.produce((BuildItem)new ServletInitParamBuildItem("org.omnifaces.COMBINED_RESOURCE_HANDLER_DISABLED", "true"));
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformBeanScope(CombinedIndexBuildItem combinedIndex) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (ctx.isClass()) {
                    ClassInfo clazz = ctx.getTarget().asClass();
                    Map annotations = clazz.annotationsMap();
                    if (annotations.containsKey(OMNIFACES_STARTUP)) {
                        LOGGER.debugf("OmniFaces found @%s annotations on a class %s - adding @ApplicationScoped", (Object)OMNIFACES_STARTUP, (Object)ctx.getTarget());
                        ((Transformation)ctx.transform().add(ApplicationScoped.class, new AnnotationValue[0])).done();
                    }
                    if (annotations.containsKey(OMNIFACES_EAGER) || annotations.containsKey(OMNIFACES_STARTUP)) {
                        LOGGER.debugf("OmniFaces found @Eager annotations on a class %s - adding @io.quarkus.runtime.Startup", (Object)ctx.getTarget());
                        ((Transformation)ctx.transform().add(io.quarkus.runtime.Startup.class, new AnnotationValue[0])).done();
                    }
                }
            }
        });
    }

    public List<String> collectClassesInPackage(CombinedIndexBuildItem combinedIndex, String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<DotName> packages = new ArrayList<DotName>(combinedIndex.getIndex().getSubpackages(packageName));
        packages.add(DotName.createSimple((String)packageName));
        for (DotName aPackage : packages) {
            List<String> packageClasses = combinedIndex.getIndex().getClassesInPackage(aPackage).stream().map(ClassInfo::toString).toList();
            classes.addAll(packageClasses);
        }
        return classes;
    }

    private List<String> collectSubclasses(CombinedIndexBuildItem combinedIndex, String className) {
        List<String> classes = combinedIndex.getIndex().getAllKnownSubclasses(DotName.createSimple((String)className)).stream().map(ClassInfo::toString).collect(Collectors.toList());
        classes.add(className);
        return classes;
    }

    public List<String> collectImplementors(CombinedIndexBuildItem combinedIndex, String className) {
        List<String> classes = combinedIndex.getIndex().getAllKnownImplementors(DotName.createSimple((String)className)).stream().map(ClassInfo::toString).collect(Collectors.toList());
        classes.add(className);
        return classes;
    }
}

