/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.TupleKey;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Assertion {
    @JsonProperty(value="tuple_key")
    private final TupleKey tupleKey;
    private final boolean expectation;
    @JsonProperty(value="contextual_tuples")
    @Nullable
    private final List<TupleKey> contextualTuples;

    Assertion(@JsonProperty(value="tuple_key") TupleKey tupleKey, boolean expectation, @JsonProperty(value="contextual_tuples") @Nullable List<TupleKey> contextualTuples) {
        this.tupleKey = Preconditions.parameterNonNull(tupleKey, "tupleKey");
        this.expectation = expectation;
        this.contextualTuples = contextualTuples;
    }

    public Assertion of(TupleKey tupleKey, boolean expectation, @Nullable List<TupleKey> contextualTuples) {
        return new Assertion(tupleKey, expectation, contextualTuples);
    }

    @JsonProperty(value="tuple_key")
    public TupleKey getTupleKey() {
        return this.tupleKey;
    }

    public boolean getExpectation() {
        return this.expectation;
    }

    @JsonProperty(value="contextual_tuples")
    @Nullable
    public List<TupleKey> getContextualTuples() {
        return this.contextualTuples;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Assertion that = (Assertion)obj;
        return Objects.equals(this.tupleKey, that.tupleKey) && this.expectation == that.expectation && Objects.equals(this.contextualTuples, that.contextualTuples);
    }

    public int hashCode() {
        return Objects.hash(this.tupleKey, this.expectation, this.contextualTuples);
    }

    public String toString() {
        return "Assertion[tupleKey=" + this.tupleKey + ", expectation=" + this.expectation + ", contextualTuples=" + this.contextualTuples + "]";
    }
}

