/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.Condition;
import io.quarkiverse.openfga.client.model.TypeDefinition;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class AuthorizationModelSchema {
    @JsonProperty(value="schema_version")
    private final String schemaVersion;
    @JsonProperty(value="type_definitions")
    private final List<TypeDefinition> typeDefinitions;
    @Nullable
    private final Map<String, Condition> conditions;

    @JsonCreator
    AuthorizationModelSchema(@JsonProperty(value="schema_version") String schemaVersion, @JsonProperty(value="type_definitions") List<TypeDefinition> typeDefinitions, @Nullable Map<String, Condition> conditions) {
        this.schemaVersion = schemaVersion;
        this.typeDefinitions = Preconditions.parameterNonNull(typeDefinitions, "typeDefinitions");
        this.conditions = conditions;
    }

    public static AuthorizationModelSchema of(String schemaVersion, List<TypeDefinition> typeDefinitions, @Nullable Map<String, Condition> conditions) {
        return new AuthorizationModelSchema(schemaVersion, typeDefinitions, conditions);
    }

    public static AuthorizationModelSchema of(@JsonProperty(value="type_definitions") List<TypeDefinition> typeDefinitions, @Nullable Map<String, Condition> conditions) {
        return AuthorizationModelSchema.of("1.1", typeDefinitions, conditions);
    }

    @JsonProperty(value="schema_version")
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="type_definitions")
    public List<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    @JsonProperty(value="conditions")
    @Nullable
    public Map<String, Condition> getConditions() {
        return this.conditions;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AuthorizationModelSchema that = (AuthorizationModelSchema)obj;
        return Objects.equals(this.schemaVersion, that.schemaVersion) && Objects.equals(this.typeDefinitions, that.typeDefinitions) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.typeDefinitions, this.conditions);
    }

    public String toString() {
        return "AuthorizationModelSchema[schemaVersion=" + this.schemaVersion + ", typeDefinitions=" + this.typeDefinitions + ", conditions=" + this.conditions + "]";
    }
}

