/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Condition {
    private final String name;
    private final String expression;
    private final Map<String, Parameter> parameters;
    private final Map<String, String> metadata;

    public Condition(String name, String expression, Map<String, Parameter> parameters, Map<String, String> metadata) {
        this.name = name;
        this.expression = expression;
        this.parameters = parameters;
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public String getExpression() {
        return this.expression;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.name, condition.name) && Objects.equals(this.expression, condition.expression) && Objects.equals(this.parameters, condition.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression, this.parameters);
    }

    public String toString() {
        return "Condition{name='" + this.name + "', expression='" + this.expression + "', parameters=" + this.parameters + "}";
    }

    public static final class Parameter {
        private final String typeName;
        private final List<String> genericTypes;

        Parameter(@JsonProperty(value="type_name") String typeName, @JsonProperty(value="generic_types") List<String> genericTypes) {
            this.typeName = typeName;
            this.genericTypes = genericTypes;
        }

        public static Parameter of(String typeName, List<String> genericTypes) {
            return new Parameter(typeName, genericTypes);
        }

        @JsonProperty(value="type_name")
        public String getTypeName() {
            return this.typeName;
        }

        @JsonProperty(value="generic_types")
        public List<String> getGenericTypes() {
            return this.genericTypes;
        }
    }
}

