/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.quarkiverse.openfga.client.model.RelationshipCondition;
import io.quarkiverse.openfga.client.model.TupleKey;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ConditionalTupleKey {
    private final String object;
    private final String relation;
    private final String user;
    @Nullable
    private final RelationshipCondition condition;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    ConditionalTupleKey(String object, String relation, String user, @Nullable RelationshipCondition condition) {
        this.object = Preconditions.parameterNonNull(object, "object");
        this.relation = Preconditions.parameterNonNull(relation, "relation");
        this.user = Preconditions.parameterNonNull(user, "user");
        this.condition = condition;
    }

    public static ConditionalTupleKey of(String object, String relation, String user, @Nullable RelationshipCondition condition) {
        return new ConditionalTupleKey(object, relation, user, condition);
    }

    public static ConditionalTupleKey of(String object, String relation, String user) {
        return new ConditionalTupleKey(object, relation, user, null);
    }

    public String getObject() {
        return this.object;
    }

    public String getRelation() {
        return this.relation;
    }

    public String getUser() {
        return this.user;
    }

    @Nullable
    public RelationshipCondition getCondition() {
        return this.condition;
    }

    public TupleKey withoutCondition() {
        return TupleKey.of(this.object, this.relation, this.user);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ConditionalTupleKey that = (ConditionalTupleKey)obj;
        return Objects.equals(this.object, that.object) && Objects.equals(this.relation, that.relation) && Objects.equals(this.user, that.user) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.relation, this.user, this.condition);
    }

    public String toString() {
        return "ConditionalTupleKey[object=" + this.object + ", relation=" + this.relation + ", user=" + this.user + ", condition=" + this.condition + "]";
    }
}

