/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.FGAException;
import javax.annotation.Nullable;

public class FGAInternalException
extends FGAException {
    private final Code code;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public FGAInternalException(@JsonProperty(value="code") Code code, @JsonProperty(value="message") @Nullable String message) {
        super(String.format("%s (%s)", message, code.name().toLowerCase()));
        this.code = code;
    }

    public Code getCode() {
        return this.code;
    }

    public static enum Code {
        NO_INTERNAL_ERROR,
        INTERNAL_ERROR,
        CANCELLED,
        DEADLINE_EXCEEDED,
        ALREADY_EXISTS,
        RESOURCE_EXHAUSTED,
        FAILED_PRECONDITION,
        ABORTED,
        OUT_OF_RANGE,
        UNAVAILABLE,
        DATA_LOSS;

    }
}

