/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.FGAException;
import javax.annotation.Nullable;

public class FGAValidationException
extends FGAException {
    private final Code code;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public FGAValidationException(@JsonProperty(value="code") Code code, @JsonProperty(value="message") @Nullable String message) {
        super(String.format("%s (%s)", message, code.name().toLowerCase()));
        this.code = code;
    }

    public Code getCode() {
        return this.code;
    }

    public static enum Code {
        NO_ERROR,
        VALIDATION_ERROR,
        AUTHORIZATION_MODEL_NOT_FOUND,
        AUTHORIZATION_MODEL_RESOLUTION_TOO_COMPLEX,
        INVALID_WRITE_INPUT,
        CANNOT_ALLOW_DUPLICATE_TUPLES_IN_ONE_REQUEST,
        CANNOT_ALLOW_DUPLICATE_TYPES_IN_ONE_REQUEST,
        CANNOT_ALLOW_MULTIPLE_REFERENCES_TO_ONE_RELATION,
        INVALID_CONTINUATION_TOKEN,
        INVALID_TUPLE_SET,
        INVALID_CHECK_INPUT,
        INVALID_EXPAND_INPUT,
        UNSUPPORTED_USER_SET,
        INVALID_OBJECT_FORMAT,
        WRITE_FAILED_DUE_TO_INVALID_INPUT,
        AUTHORIZATION_MODEL_ASSERTIONS_NOT_FOUND,
        LATEST_AUTHORIZATION_MODEL_NOT_FOUND,
        TYPE_NOT_FOUND,
        RELATION_NOT_FOUND,
        EMPTY_RELATION_DEFINITION,
        INVALID_USER,
        INVALID_TUPLE,
        UNKNOWN_RELATION,
        STORE_ID_INVALID_LENGTH,
        ASSERTIONS_TOO_MANY_ITEMS,
        ID_TOO_LONG,
        AUTHORIZATION_MODEL_ID_TOO_LONG,
        TUPLE_KEY_VALUE_NOT_SPECIFIED,
        TUPLE_KEYS_TOO_MANY_OR_TOO_FEW_ITEMS,
        PAGE_SIZE_INVALID,
        PARAM_MISSING_VALUE,
        DIFFERENCE_BASE_MISSING_VALUE,
        SUBTRACT_BASE_MISSING_VALUE,
        OBJECT_TOO_LONG,
        RELATION_TOO_LONG,
        TYPE_DEFINITIONS_TOO_FEW_ITEMS,
        TYPE_INVALID_LENGTH,
        TYPE_INVALID_PATTERN,
        RELATIONS_TOO_FEW_ITEMS,
        RELATIONS_TOO_LONG,
        RELATIONS_INVALID_PATTERN,
        OBJECT_INVALID_PATTERN,
        QUERY_STRING_TYPE_CONTINUATION_TOKEN_MISMATCH,
        EXCEEDED_ENTITY_LIMIT,
        INVALID_CONTEXTUAL_TUPLE,
        DUPLICATE_CONTEXTUAL_TUPLE,
        INVALID_AUTHORIZATION_MODEL,
        UNSUPPORTED_SCHEMA_VERSION;

    }
}

