/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.RelationMetadata;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Metadata {
    @Nullable
    private final Map<String, RelationMetadata> relations;
    @Nullable
    private final String module;
    @JsonProperty(value="source_info")
    @Nullable
    private final String sourceInfo;

    @JsonCreator
    Metadata(@Nullable Map<String, RelationMetadata> relations, @Nullable String module, @Nullable String sourceInfo) {
        this.relations = relations;
        this.module = module;
        this.sourceInfo = sourceInfo;
    }

    public static Metadata of(@Nullable Map<String, RelationMetadata> relations, @Nullable String module, @Nullable String sourceInfo) {
        return new Metadata(relations, module, sourceInfo);
    }

    public static Metadata of(@Nullable Map<String, RelationMetadata> relations) {
        return Metadata.of(relations, null, null);
    }

    @Nullable
    public Map<String, RelationMetadata> getRelations() {
        return this.relations;
    }

    @Nullable
    public String getModule() {
        return this.module;
    }

    @JsonProperty(value="source_info")
    @Nullable
    public String getSourceInfo() {
        return this.sourceInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.relations, metadata.relations) && Objects.equals(this.module, metadata.module) && Objects.equals(this.sourceInfo, metadata.sourceInfo);
    }

    public int hashCode() {
        return Objects.hash(this.relations, this.module, this.sourceInfo);
    }

    public String toString() {
        return "Metadata{relations=" + this.relations + ", module=" + this.module + ", sourceInfo=" + this.sourceInfo + "}";
    }
}

