/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Objects;
import javax.annotation.Nullable;

public final class RelationReference {
    private final String type;
    @Nullable
    private final String relation;
    @Nullable
    private final Object wildcard;
    @Nullable
    private final String condition;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    RelationReference(String type, @Nullable String relation, @Nullable Object wildcard, @Nullable String condition) {
        this.type = type;
        this.relation = relation;
        this.wildcard = wildcard;
        this.condition = condition;
    }

    public static RelationReference of(String type, @Nullable String relation, @Nullable Object wildcard, @Nullable String condition) {
        return new RelationReference(type, relation, wildcard, condition);
    }

    public static RelationReference of(String type) {
        return RelationReference.of(type, null, null, null);
    }

    public static RelationReference of(String type, String relation) {
        return RelationReference.of(type, relation, null, null);
    }

    public String getType() {
        return this.type;
    }

    @Nullable
    public String getRelation() {
        return this.relation;
    }

    @Nullable
    public Object getWildcard() {
        return this.wildcard;
    }

    @Nullable
    public String getCondition() {
        return this.condition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelationReference)) {
            return false;
        }
        RelationReference that = (RelationReference)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.relation, that.relation) && Objects.equals(this.wildcard, that.wildcard) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.relation, this.wildcard, this.condition);
    }

    public String toString() {
        return "RelationReference{type='" + this.type + "', relation='" + this.relation + "', wildcard=" + this.wildcard + "', condition='" + this.condition + "'}";
    }
}

