/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.quarkiverse.openfga.client.model.ConditionalTupleKey;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Tuple {
    private final ConditionalTupleKey key;
    private final OffsetDateTime timestamp;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    Tuple(ConditionalTupleKey key, OffsetDateTime timestamp) {
        this.key = Preconditions.parameterNonNull(key, "key");
        this.timestamp = Preconditions.parameterNonNull(timestamp, "timestamp");
    }

    public static Tuple of(ConditionalTupleKey key, OffsetDateTime timestamp) {
        return new Tuple(key, timestamp);
    }

    public ConditionalTupleKey getKey() {
        return this.key;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Tuple that = (Tuple)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.timestamp);
    }

    public String toString() {
        return "Tuple[key=" + this.key + ", timestamp=" + this.timestamp + "]";
    }
}

