/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.quarkiverse.openfga.client.model.ConditionalTupleKey;
import io.quarkiverse.openfga.client.model.RelationshipCondition;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TupleKey {
    private final String object;
    private final String relation;
    private final String user;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    TupleKey(String object, String relation, String user) {
        this.object = Preconditions.parameterNonNull(object, "object");
        this.relation = Preconditions.parameterNonNull(relation, "relation");
        this.user = Preconditions.parameterNonNull(user, "user");
    }

    public static TupleKey of(String object, String relation, String user) {
        return new TupleKey(object, relation, user);
    }

    public String getObject() {
        return this.object;
    }

    public String getRelation() {
        return this.relation;
    }

    public String getUser() {
        return this.user;
    }

    public ConditionalTupleKey condition(@Nullable RelationshipCondition condition) {
        return new ConditionalTupleKey(this.object, this.relation, this.user, condition);
    }

    public ConditionalTupleKey nullCondition() {
        return new ConditionalTupleKey(this.object, this.relation, this.user, null);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TupleKey that = (TupleKey)obj;
        return Objects.equals(this.object, that.object) && Objects.equals(this.relation, that.relation) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.relation, this.user);
    }

    public String toString() {
        return "TupleKey[object=" + this.object + ", relation=" + this.relation + ", user=" + this.user + "]";
    }
}

