/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.quarkiverse.openfga.client.model.AnyObject;
import io.quarkiverse.openfga.client.model.TypedWildcard;
import io.quarkiverse.openfga.client.model.UsersetUser;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class User {
    @Nullable
    private final AnyObject object;
    @Nullable
    private final UsersetUser userset;
    @Nullable
    private final TypedWildcard wildcard;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    User(@Nullable AnyObject object, @Nullable UsersetUser userset, @Nullable TypedWildcard wildcard) {
        Preconditions.oneOfNonNull("User must have exactly one of object, userset, wildcard", object, userset, wildcard);
        this.object = object;
        this.userset = userset;
        this.wildcard = wildcard;
    }

    public static User object(AnyObject object) {
        return new User(object, null, null);
    }

    public static User object(String type, String id) {
        return User.object(AnyObject.of(type, id));
    }

    public static User userset(UsersetUser userset) {
        return new User(null, userset, null);
    }

    public static User userset(String type, String id, String relation) {
        return User.userset(UsersetUser.of(type, id, relation));
    }

    public static User wildcard(TypedWildcard wildcard) {
        return new User(null, null, wildcard);
    }

    public static User wildcard(String type) {
        return User.wildcard(TypedWildcard.of(type));
    }

    @Nullable
    public Object getObject() {
        return this.object;
    }

    @Nullable
    public UsersetUser getUserset() {
        return this.userset;
    }

    @Nullable
    public TypedWildcard getWildcard() {
        return this.wildcard;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        User that = (User)obj;
        return Objects.equals(this.object, that.object) && Objects.equals(this.userset, that.userset) && Objects.equals(this.wildcard, that.wildcard);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.userset, this.wildcard);
    }

    public String toString() {
        return "User[object=" + this.object + ", userset=" + this.userset + ", wildcard=" + this.wildcard + "]";
    }
}

