/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class UserTypeFilter {
    private final String type;
    @Nullable
    private final String relation;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    UserTypeFilter(String type, @Nullable String relation) {
        this.type = Preconditions.parameterNonNull(type, "type");
        this.relation = relation;
    }

    public static UserTypeFilter of(String type) {
        return UserTypeFilter.of(type, null);
    }

    public static UserTypeFilter of(String type, @Nullable String relation) {
        return new UserTypeFilter(type, relation);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    @Nullable
    public String getRelation() {
        return this.relation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTypeFilter that = (UserTypeFilter)o;
        return this.type.equals(that.type) && Objects.equals(this.relation, that.relation);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.relation);
    }

    public String toString() {
        return "UserTypeFilter[type='" + this.type + "', relation='" + this.relation + "]";
    }

    public static final class Builder {
        private String type;
        private String relation;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder relation(@Nullable String relation) {
            this.relation = relation;
            return this;
        }

        public UserTypeFilter build() {
            return new UserTypeFilter(this.type, this.relation);
        }
    }
}

