/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.ConsistencyPreference;
import io.quarkiverse.openfga.client.model.ContextualTupleKeys;
import io.quarkiverse.openfga.client.model.TupleKey;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class CheckRequest {
    @JsonProperty(value="tuple_key")
    private final TupleKey tupleKey;
    @JsonProperty(value="contextual_tuples")
    @Nullable
    private final ContextualTupleKeys contextualTuples;
    @JsonProperty(value="authorization_model_id")
    @Nullable
    private final String authorizationModelId;
    @Nullable
    private final Boolean trace;
    @Nullable
    private final Object context;
    @Nullable
    private final ConsistencyPreference consistency;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    CheckRequest(@JsonProperty(value="tuple_key") TupleKey tupleKey, @JsonProperty(value="contextual_tuples") @Nullable ContextualTupleKeys contextualTuples, @JsonProperty(value="authorization_model_id") @Nullable String authorizationModelId, @Nullable Boolean trace, @Nullable Object context, @Nullable ConsistencyPreference consistency) {
        this.tupleKey = Preconditions.parameterNonNull(tupleKey, "tupleKey");
        this.contextualTuples = contextualTuples;
        this.authorizationModelId = authorizationModelId;
        this.trace = trace;
        this.context = context;
        this.consistency = consistency;
    }

    public static CheckRequest of(TupleKey tupleKey, @Nullable ContextualTupleKeys contextualTuples, @Nullable String authorizationModelId, @Nullable Boolean trace, @Nullable Object context, @Nullable ConsistencyPreference consistency) {
        return new CheckRequest(tupleKey, contextualTuples, authorizationModelId, trace, context, consistency);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="tuple_key")
    public TupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="contextual_tuples")
    @Nullable
    public ContextualTupleKeys getContextualTuples() {
        return this.contextualTuples;
    }

    @JsonProperty(value="authorization_model_id")
    @Nullable
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @Nullable
    public Boolean getTrace() {
        return this.trace;
    }

    @Nullable
    public Object getContext() {
        return this.context;
    }

    @Nullable
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CheckRequest that = (CheckRequest)obj;
        return Objects.equals(this.tupleKey, that.tupleKey) && Objects.equals(this.contextualTuples, that.contextualTuples) && Objects.equals(this.authorizationModelId, that.authorizationModelId) && Objects.equals(this.trace, that.trace) && Objects.equals(this.context, that.context) && Objects.equals((Object)this.consistency, (Object)that.consistency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tupleKey, this.contextualTuples, this.authorizationModelId, this.trace, this.context, this.consistency});
    }

    public String toString() {
        return "CheckRequest[tupleKey=" + this.tupleKey + ", contextualTupleKeys=" + this.contextualTuples + ", authorizationModelId=" + this.authorizationModelId + ", trace=" + this.trace + ", context=" + this.context + ", consistency=" + this.consistency + "]";
    }

    public static final class Builder {
        private TupleKey tupleKey;
        private ContextualTupleKeys contextualTuples;
        private String authorizationModelId;
        private Boolean trace;
        private Object context;
        private ConsistencyPreference consistency;

        Builder() {
        }

        public Builder tupleKey(TupleKey tupleKey) {
            this.tupleKey = tupleKey;
            return this;
        }

        public Builder contextualTuples(@Nullable ContextualTupleKeys contextualTuples) {
            this.contextualTuples = contextualTuples;
            return this;
        }

        public Builder authorizationModelId(@Nullable String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder trace(@Nullable Boolean trace) {
            this.trace = trace;
            return this;
        }

        public Builder context(@Nullable Object context) {
            this.context = context;
            return this;
        }

        public Builder consistency(@Nullable ConsistencyPreference consistency) {
            this.consistency = consistency;
            return this;
        }

        public CheckRequest build() {
            return new CheckRequest(this.tupleKey, this.contextualTuples, this.authorizationModelId, this.trace, this.context, this.consistency);
        }
    }
}

