/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.Tuple;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ReadResponse {
    private final List<Tuple> tuples;
    @JsonProperty(value="continuation_token")
    private final String continuationToken;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ReadResponse(List<Tuple> tuples, @JsonProperty(value="continuation_token") String continuationToken) {
        this.tuples = Preconditions.parameterNonNull(tuples, "tuples");
        this.continuationToken = Preconditions.parameterNonNull(continuationToken, "continuationToken");
    }

    public List<Tuple> getTuples() {
        return this.tuples;
    }

    @JsonProperty(value="continuation_token")
    public String getContinuationToken() {
        return this.continuationToken;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ReadResponse that = (ReadResponse)obj;
        return Objects.equals(this.tuples, that.tuples) && Objects.equals(this.continuationToken, that.continuationToken);
    }

    public int hashCode() {
        return Objects.hash(this.tuples, this.continuationToken);
    }

    public String toString() {
        return "ReadResponse[tuples=" + this.tuples + ", continuationToken=" + this.continuationToken + "]";
    }
}

