/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.Assertion;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class WriteAssertionsRequest {
    @JsonProperty(value="authorization_model_id")
    private final String authorizationModelId;
    private final List<Assertion> assertions;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    WriteAssertionsRequest(@JsonProperty(value="authorization_model_id") String authorizationModelId, List<Assertion> assertions) {
        this.authorizationModelId = Preconditions.parameterNonNull(authorizationModelId, "authorizationModelId");
        this.assertions = Preconditions.parameterNonNull(assertions, "assertions");
    }

    public static WriteAssertionsRequest of(String authorizationModelId, List<Assertion> assertions) {
        return new WriteAssertionsRequest(authorizationModelId, assertions);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="authorization_model_id")
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    public List<Assertion> getAssertions() {
        return this.assertions;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        WriteAssertionsRequest that = (WriteAssertionsRequest)obj;
        return Objects.equals(this.assertions, that.assertions) && Objects.equals(this.authorizationModelId, that.authorizationModelId);
    }

    public int hashCode() {
        return Objects.hash(this.assertions, this.authorizationModelId);
    }

    public String toString() {
        return "WriteAssertionsRequest[assertions=" + this.assertions + ", authorizationModelId=" + this.authorizationModelId + "]";
    }

    public static final class Builder {
        private String authorizationModelId;
        private List<Assertion> assertions;

        public Builder authorizationModelId(String authorizationModelId) {
            this.authorizationModelId = authorizationModelId;
            return this;
        }

        public Builder assertions(List<Assertion> assertions) {
            this.assertions = assertions;
            return this;
        }

        public Builder addAssertions(List<Assertion> assertions) {
            if (this.assertions == null) {
                this.assertions = new ArrayList<Assertion>();
            }
            this.assertions.addAll(assertions);
            return this;
        }

        public Builder addAssertion(Assertion assertion) {
            if (this.assertions == null) {
                this.assertions = new ArrayList<Assertion>();
            }
            this.assertions.add(assertion);
            return this;
        }

        public WriteAssertionsRequest build() {
            return new WriteAssertionsRequest(this.authorizationModelId, this.assertions);
        }
    }
}

