/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.nodes;

import io.quarkiverse.openfga.client.model.nodes.Computed;
import io.quarkiverse.openfga.client.model.nodes.TupleToUserset;
import io.quarkiverse.openfga.client.model.nodes.Users;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Leaf {
    @Nullable
    private final Users users;
    @Nullable
    private final Computed computed;
    @Nullable
    private final TupleToUserset tupleToUserset;

    public Leaf(@Nullable Users users, @Nullable Computed computed, @Nullable TupleToUserset tupleToUserset) {
        Preconditions.oneOfNonNull("Leaf must have exactly one of users, computed, tupleToUserset", users, computed, tupleToUserset);
        this.users = users;
        this.computed = computed;
        this.tupleToUserset = tupleToUserset;
    }

    @Nullable
    public Users getUsers() {
        return this.users;
    }

    @Nullable
    public Computed getComputed() {
        return this.computed;
    }

    @Nullable
    public TupleToUserset getTupleToUserset() {
        return this.tupleToUserset;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Leaf that = (Leaf)obj;
        return Objects.equals(this.users, that.users) && Objects.equals(this.computed, that.computed) && Objects.equals(this.tupleToUserset, that.tupleToUserset);
    }

    public int hashCode() {
        return Objects.hash(this.users, this.computed, this.tupleToUserset);
    }

    public String toString() {
        return "Leaf[users=" + this.users + ", computed=" + this.computed + ", tupleToUserset=" + this.tupleToUserset + "]";
    }
}

