/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client;

import io.quarkiverse.openfga.client.ClientConfig;
import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.model.Assertion;
import io.quarkiverse.openfga.client.model.dto.ReadAssertionsResponse;
import io.quarkiverse.openfga.client.model.dto.WriteAssertionsRequest;
import io.smallrye.mutiny.Uni;
import java.util.List;

public class AssertionsClient {
    private final API api;
    private final Uni<ClientConfig> config;

    public AssertionsClient(API api, Uni<ClientConfig> config) {
        this.api = api;
        this.config = config;
    }

    public Uni<List<Assertion>> list() {
        return this.config.flatMap(config -> this.api.readAssertions(config.getStoreId(), config.getAuthorizationModelId())).map(ReadAssertionsResponse::getAssertions);
    }

    public Uni<Void> update(List<Assertion> assertions) {
        return this.config.flatMap(config -> {
            WriteAssertionsRequest request = WriteAssertionsRequest.builder().authorizationModelId(config.getAuthorizationModelId()).assertions(assertions).build();
            return this.api.writeAssertions(config.getStoreId(), request);
        });
    }
}

