/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client;

import io.quarkiverse.openfga.client.AuthorizationModelClient;
import io.quarkiverse.openfga.client.ClientConfig;
import io.quarkiverse.openfga.client.OpenFGAClient;
import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.model.AuthorizationModel;
import io.quarkiverse.openfga.client.model.AuthorizationModelSchema;
import io.quarkiverse.openfga.client.model.Condition;
import io.quarkiverse.openfga.client.model.TypeDefinition;
import io.quarkiverse.openfga.client.model.dto.ListAuthorizationModelsRequest;
import io.quarkiverse.openfga.client.model.dto.WriteAuthorizationModelRequest;
import io.quarkiverse.openfga.client.model.dto.WriteAuthorizationModelResponse;
import io.quarkiverse.openfga.client.utils.PaginatedList;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class AuthorizationModelsClient {
    private final API api;
    private final Uni<String> storeId;

    public AuthorizationModelsClient(API api, Uni<String> storeId) {
        this.api = api;
        this.storeId = storeId;
    }

    public Uni<PaginatedList<AuthorizationModel>> list(@Nullable Integer pageSize, @Nullable String pagingToken) {
        return this.storeId.flatMap(storeId -> {
            ListAuthorizationModelsRequest request = ListAuthorizationModelsRequest.builder().pageSize(pageSize).continuationToken(pagingToken).build();
            return this.api.listAuthorizationModels((String)storeId, request);
        }).map(res -> new PaginatedList(res.getAuthorizationModels(), res.getContinuationToken()));
    }

    public Uni<List<AuthorizationModel>> listAll() {
        return this.listAll(null);
    }

    public Uni<List<AuthorizationModel>> listAll(@Nullable Integer pageSize) {
        return PaginatedList.collectAllPages(pageSize, this::list);
    }

    public Uni<String> create(AuthorizationModelSchema schema) {
        return this.create(schema.getSchemaVersion(), schema.getTypeDefinitions(), schema.getConditions());
    }

    public Uni<String> create(String schemaVersion, List<TypeDefinition> typeDefinitions, @Nullable Map<String, Condition> conditions) {
        WriteAuthorizationModelRequest request = WriteAuthorizationModelRequest.builder().schemaVersion(schemaVersion).typeDefinitions(typeDefinitions).conditions(conditions).build();
        return this.storeId.flatMap(storeId -> this.api.writeAuthorizationModel((String)storeId, request)).map(WriteAuthorizationModelResponse::getAuthorizationModelId);
    }

    public AuthorizationModelClient model(String authorizationModelId) {
        return new AuthorizationModelClient(this.api, (Uni<ClientConfig>)this.storeId.map(storeId -> new ClientConfig((String)storeId, authorizationModelId)));
    }

    public AuthorizationModelClient defaultModel() {
        Uni config = this.storeId.flatMap(storeId -> OpenFGAClient.authorizationModelIdResolver(this.api, storeId).map(modelId -> new ClientConfig((String)storeId, (String)modelId)));
        return new AuthorizationModelClient(this.api, (Uni<ClientConfig>)config);
    }
}

