/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client;

import io.quarkiverse.openfga.client.AssertionsClient;
import io.quarkiverse.openfga.client.AuthorizationModelsClient;
import io.quarkiverse.openfga.client.ClientConfig;
import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.model.Store;
import io.quarkiverse.openfga.client.model.Tuple;
import io.quarkiverse.openfga.client.model.TupleChange;
import io.quarkiverse.openfga.client.model.dto.GetStoreResponse;
import io.quarkiverse.openfga.client.model.dto.ListChangesRequest;
import io.quarkiverse.openfga.client.model.dto.ListChangesResponse;
import io.quarkiverse.openfga.client.model.dto.ReadRequest;
import io.quarkiverse.openfga.client.utils.PaginatedList;
import io.smallrye.mutiny.Uni;
import java.util.List;
import javax.annotation.Nullable;

public class StoreClient {
    private final API api;
    private final Uni<String> storeId;

    public StoreClient(API api, Uni<String> storeId) {
        this.api = api;
        this.storeId = storeId;
    }

    public Uni<Store> get() {
        return this.storeId.flatMap(this.api::getStore).map(GetStoreResponse::asStore);
    }

    public Uni<Void> delete() {
        return this.storeId.flatMap(this.api::deleteStore);
    }

    public Uni<List<TupleChange>> listChanges(@Nullable String type, @Nullable Integer pageSize, @Nullable String continuationToken) {
        ListChangesRequest request = ListChangesRequest.builder().type(type).pageSize(pageSize).continuationToken(continuationToken).build();
        return this.storeId.flatMap(storeId -> this.api.listChanges((String)storeId, request)).map(ListChangesResponse::getChanges);
    }

    public Uni<PaginatedList<Tuple>> readTuples(@Nullable Integer pageSize, @Nullable String continuationToken) {
        ReadRequest request = ReadRequest.builder().pageSize(pageSize).continuationToken(continuationToken).build();
        return this.storeId.flatMap(storeId -> this.api.read((String)storeId, request)).map(res -> new PaginatedList(res.getTuples(), res.getContinuationToken()));
    }

    public Uni<List<Tuple>> readAllTuples() {
        return this.readAllTuples(null);
    }

    public Uni<List<Tuple>> readAllTuples(@Nullable Integer pageSize) {
        return PaginatedList.collectAllPages(pageSize, this::readTuples);
    }

    public AuthorizationModelsClient authorizationModels() {
        return new AuthorizationModelsClient(this.api, this.storeId);
    }

    public AssertionsClient assertions(String authorizationModelId) {
        return new AssertionsClient(this.api, (Uni<ClientConfig>)this.storeId.map(storeId -> new ClientConfig((String)storeId, authorizationModelId)));
    }
}

