/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.runtime;

import io.quarkiverse.openfga.client.AuthorizationModelClient;
import io.quarkiverse.openfga.client.ClientConfig;
import io.quarkiverse.openfga.client.OpenFGAClient;
import io.quarkiverse.openfga.client.StoreClient;
import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.runtime.config.OpenFGAConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import java.util.function.Supplier;

@Recorder
public class OpenFGARecorder {
    public RuntimeValue<API> createAPI(OpenFGAConfig config, boolean tracingEnabled, RuntimeValue<Vertx> vertx, Supplier<TlsConfigurationRegistry> tlsRegistry, ShutdownContext shutdownContext) {
        API api = new API(config, tracingEnabled, io.vertx.mutiny.core.Vertx.newInstance((Vertx)((Vertx)vertx.getValue())), tlsRegistry.get());
        shutdownContext.addShutdownTask(api::close);
        return new RuntimeValue((Object)api);
    }

    public RuntimeValue<OpenFGAClient> createClient(RuntimeValue<API> api) {
        OpenFGAClient openFGAClient = new OpenFGAClient((API)api.getValue());
        return new RuntimeValue((Object)openFGAClient);
    }

    public RuntimeValue<StoreClient> createStoreClient(RuntimeValue<API> api, OpenFGAConfig config) {
        Uni<String> storeIdResolver = OpenFGAClient.storeIdResolver((API)api.getValue(), config.store(), config.alwaysResolveStoreId());
        StoreClient storeClient = new StoreClient((API)api.getValue(), storeIdResolver);
        return new RuntimeValue((Object)storeClient);
    }

    public RuntimeValue<AuthorizationModelClient> createAuthModelClient(RuntimeValue<API> api, OpenFGAConfig config) {
        Uni configResolver = OpenFGAClient.storeIdResolver((API)api.getValue(), config.store(), config.alwaysResolveStoreId()).flatMap(storeId -> OpenFGAClient.authorizationModelIdResolver((API)api.getValue(), storeId).map(modelId -> new ClientConfig((String)storeId, (String)modelId)));
        AuthorizationModelClient authModelClient = new AuthorizationModelClient((API)api.getValue(), (Uni<ClientConfig>)configResolver);
        return new RuntimeValue((Object)authModelClient);
    }
}

