/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client;

import io.quarkiverse.openfga.client.ClientConfig;
import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.model.AnyObject;
import io.quarkiverse.openfga.client.model.AuthorizationModel;
import io.quarkiverse.openfga.client.model.ConditionalTupleKey;
import io.quarkiverse.openfga.client.model.ConsistencyPreference;
import io.quarkiverse.openfga.client.model.ContextualTupleKeys;
import io.quarkiverse.openfga.client.model.ExpandTupleKey;
import io.quarkiverse.openfga.client.model.PartialTupleKey;
import io.quarkiverse.openfga.client.model.Tuple;
import io.quarkiverse.openfga.client.model.TupleKey;
import io.quarkiverse.openfga.client.model.User;
import io.quarkiverse.openfga.client.model.UserTypeFilter;
import io.quarkiverse.openfga.client.model.UsersetTree;
import io.quarkiverse.openfga.client.model.dto.CheckRequest;
import io.quarkiverse.openfga.client.model.dto.CheckResponse;
import io.quarkiverse.openfga.client.model.dto.ExpandRequest;
import io.quarkiverse.openfga.client.model.dto.ExpandResponse;
import io.quarkiverse.openfga.client.model.dto.ListObjectsRequest;
import io.quarkiverse.openfga.client.model.dto.ListObjectsResponse;
import io.quarkiverse.openfga.client.model.dto.ListUsersRequest;
import io.quarkiverse.openfga.client.model.dto.ListUsersResponse;
import io.quarkiverse.openfga.client.model.dto.ReadAuthorizationModelResponse;
import io.quarkiverse.openfga.client.model.dto.ReadRequest;
import io.quarkiverse.openfga.client.model.dto.WriteRequest;
import io.quarkiverse.openfga.client.model.dto.WriteResponse;
import io.quarkiverse.openfga.client.utils.PaginatedList;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class AuthorizationModelClient {
    private final API api;
    private final Uni<ClientConfig> config;

    public AuthorizationModelClient(API api, Uni<ClientConfig> config) {
        this.api = api;
        this.config = config;
    }

    public Uni<AuthorizationModel> get() {
        return this.config.flatMap(config -> this.api.readAuthorizationModel(config.getStoreId(), config.getAuthorizationModelId())).map(ReadAuthorizationModelResponse::getAuthorizationModel);
    }

    public Uni<Boolean> check(TupleKey tupleKey) {
        return this.check(tupleKey, null, null, null);
    }

    public Uni<Boolean> check(TupleKey tupleKey, @Nullable List<ConditionalTupleKey> conditionalTuples) {
        return this.check(tupleKey, conditionalTuples, null, null);
    }

    public Uni<Boolean> check(TupleKey tupleKey, @Nullable List<ConditionalTupleKey> conditionalTuples, @Nullable Object context) {
        return this.check(tupleKey, conditionalTuples, context, null);
    }

    public Uni<Boolean> check(TupleKey tupleKey, @Nullable List<ConditionalTupleKey> conditionalTuples, @Nullable Object context, @Nullable ConsistencyPreference consistency) {
        return this.config.flatMap(config -> {
            CheckRequest request = CheckRequest.builder().authorizationModelId(config.getAuthorizationModelId()).tupleKey(tupleKey).contextualTuples(ContextualTupleKeys.of((List)conditionalTuples)).context(context).consistency(consistency).build();
            return this.api.check(config.getStoreId(), request);
        }).map(CheckResponse::getAllowed);
    }

    public Uni<UsersetTree> expand(ExpandTupleKey tupleKey) {
        return this.expand(tupleKey, null);
    }

    public Uni<UsersetTree> expand(ExpandTupleKey tupleKey, @Nullable ConsistencyPreference consistency) {
        return this.config.flatMap(config -> {
            ExpandRequest request = ExpandRequest.builder().tupleKey(tupleKey).authorizationModelId(config.getAuthorizationModelId()).consistency(consistency).build();
            return this.api.expand(config.getStoreId(), request);
        }).map(ExpandResponse::getTree);
    }

    public Uni<List<String>> listObjects(String type, String relation, String user) {
        return this.listObjects(type, relation, user, null);
    }

    public Uni<List<String>> listObjects(String type, String relation, String user, @Nullable Options options) {
        return this.config.flatMap(config -> {
            Options opts = options == null ? new Options() : options;
            ListObjectsRequest request = ListObjectsRequest.builder().authorizationModelId(config.getAuthorizationModelId()).type(type).relation(relation).user(user).contextualTuples(ContextualTupleKeys.of(opts.contextualTuples)).context(opts.context).consistency(opts.consistency).build();
            return this.api.listObjects(config.getStoreId(), request);
        }).map(ListObjectsResponse::getObjects);
    }

    public Uni<List<User>> listUsers(AnyObject object, String relation, List<UserTypeFilter> userFilters) {
        return this.listUsers(object, relation, userFilters, null);
    }

    public Uni<List<User>> listUsers(AnyObject object, String relation, List<UserTypeFilter> userFilters, @Nullable Options options) {
        return this.config.flatMap(config -> {
            Options opts = options == null ? new Options() : options;
            ListUsersRequest request = ListUsersRequest.builder().authorizationModelId(config.getAuthorizationModelId()).object(object).relation(relation).userFilters(userFilters).contextualTuples(ContextualTupleKeys.of(opts.contextualTuples)).context(opts.context).consistency(opts.consistency).build();
            return this.api.listUsers(config.getStoreId(), request);
        }).map(ListUsersResponse::getUsers);
    }

    public Uni<PaginatedList<Tuple>> queryTuples(PartialTupleKey tupleKey, @Nullable Integer pageSize, @Nullable String continuationToken) {
        return this.config.flatMap(config -> {
            ReadRequest request = ReadRequest.builder().tupleKey(tupleKey).authorizationModelId(config.getAuthorizationModelId()).pageSize(pageSize).continuationToken(continuationToken).build();
            return this.api.read(config.getStoreId(), request);
        }).map(res -> new PaginatedList(res.getTuples(), res.getContinuationToken()));
    }

    public Uni<List<Tuple>> queryAllTuples(PartialTupleKey tupleKey) {
        return this.queryAllTuples(tupleKey, null);
    }

    public Uni<List<Tuple>> queryAllTuples(PartialTupleKey tupleKey, @Nullable Integer pageSize) {
        return PaginatedList.collectAllPages(pageSize, (currentPageSize, currentToken) -> this.queryTuples(tupleKey, (Integer)currentPageSize, (String)currentToken));
    }

    public Uni<PaginatedList<Tuple>> readTuples(@Nullable Integer pageSize, @Nullable String continuationToken) {
        return this.config.flatMap(config -> {
            ReadRequest request = ReadRequest.builder().authorizationModelId(config.getAuthorizationModelId()).pageSize(pageSize).continuationToken(continuationToken).build();
            return this.api.read(config.getStoreId(), request);
        }).map(res -> new PaginatedList(res.getTuples(), res.getContinuationToken()));
    }

    public Uni<List<Tuple>> readAllTuples() {
        return this.readAllTuples(null);
    }

    public Uni<List<Tuple>> readAllTuples(@Nullable Integer pageSize) {
        return PaginatedList.collectAllPages(pageSize, this::readTuples);
    }

    public Uni<Void> write(ConditionalTupleKey tupleKey) {
        return this.write(List.of(tupleKey), null).replaceWithVoid();
    }

    public Uni<Map<String, Object>> write(@Nullable List<ConditionalTupleKey> writes, @Nullable List<TupleKey> deletes) {
        return this.config.flatMap(config -> {
            WriteRequest request = WriteRequest.builder().authorizationModelId(config.getAuthorizationModelId()).writes(WriteRequest.Writes.of((List)writes)).deletes(WriteRequest.Deletes.of((List)deletes)).build();
            return this.api.write(config.getStoreId(), request);
        }).map(WriteResponse::getValues);
    }

    public static final class Options {
        private List<ConditionalTupleKey> contextualTuples = null;
        private Object context = null;
        private ConsistencyPreference consistency = null;

        public Options contextualTuples(List<ConditionalTupleKey> contextualTuples) {
            this.contextualTuples = contextualTuples;
            return this;
        }

        public Options context(Object context) {
            this.context = context;
            return this;
        }

        public Options consistency(ConsistencyPreference consistency) {
            this.consistency = consistency;
            return this;
        }
    }
}

