/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client;

import io.quarkiverse.openfga.client.StoreClient;
import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.model.AuthorizationModel;
import io.quarkiverse.openfga.client.model.FGAValidationException;
import io.quarkiverse.openfga.client.model.Store;
import io.quarkiverse.openfga.client.model.dto.CreateStoreRequest;
import io.quarkiverse.openfga.client.model.dto.CreateStoreResponse;
import io.quarkiverse.openfga.client.model.dto.ListAuthorizationModelsRequest;
import io.quarkiverse.openfga.client.model.dto.ListAuthorizationModelsResponse;
import io.quarkiverse.openfga.client.model.dto.ListStoresRequest;
import io.quarkiverse.openfga.client.utils.PaginatedList;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class OpenFGAClient {
    private final API api;
    private static final Pattern STORE_ID_PATTERN = Pattern.compile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$");

    public OpenFGAClient(API api) {
        this.api = api;
    }

    public Uni<PaginatedList<Store>> listStores(@Nullable Integer pageSize, @Nullable String continuationToken) {
        ListStoresRequest request = ListStoresRequest.builder().pageSize(pageSize).continuationToken(continuationToken).build();
        return this.api.listStores(request).map(res -> new PaginatedList(res.getStores(), res.getContinuationToken()));
    }

    public Uni<List<Store>> listAllStores() {
        return this.listAllStores(null);
    }

    public Uni<List<Store>> listAllStores(@Nullable Integer pageSize) {
        return PaginatedList.collectAllPages(pageSize, this::listStores);
    }

    public Uni<Store> createStore(String name) {
        CreateStoreRequest request = CreateStoreRequest.builder().name(name).build();
        return this.api.createStore(request).map(CreateStoreResponse::toStore);
    }

    public StoreClient store(String storeId) {
        return new StoreClient(this.api, (Uni<String>)Uni.createFrom().item((Object)storeId));
    }

    public static Uni<String> storeIdResolver(API api, String storeIdOrName, boolean alwaysResolveStoreId) {
        if (STORE_ID_PATTERN.matcher(storeIdOrName).matches() && !alwaysResolveStoreId) {
            return Uni.createFrom().item((Object)storeIdOrName);
        }
        return Multi.createBy().repeating().uni(AtomicReference::new, lastToken -> {
            ListStoresRequest request = ListStoresRequest.builder().continuationToken((String)lastToken.get()).build();
            return api.listStores(request).onItem().invoke(list -> lastToken.set(list.getContinuationToken())).map(response -> {
                Optional<String> storeId = response.getStores().stream().filter(store -> store.getName().equals(storeIdOrName) || store.getId().equals(storeIdOrName)).map(Store::getId).findFirst();
                Optional<String> token = response.getContinuationToken() != null && !response.getContinuationToken().isEmpty() ? Optional.of(response.getContinuationToken()) : Optional.empty();
                return new StoreSearchResult(storeId, token);
            });
        }).whilst(StoreSearchResult::isNotFinished).select().last().flatMap(result -> {
            if (result.storeId.isEmpty() && result.token.isEmpty()) {
                return Multi.createFrom().failure((Throwable)new IllegalStateException(String.format("No store with name '%s'", storeIdOrName)));
            }
            if (result.storeId.isEmpty()) {
                return Multi.createFrom().nothing();
            }
            return Multi.createFrom().item((Object)result.storeId.get());
        }).toUni().memoize().indefinitely();
    }

    public static Uni<String> authorizationModelIdResolver(API api, String storeId) {
        return api.listAuthorizationModels(storeId, ListAuthorizationModelsRequest.builder().pageSize(Integer.valueOf(1)).build()).map(ListAuthorizationModelsResponse::getAuthorizationModels).flatMap(models -> {
            if (models.isEmpty()) {
                FGAValidationException notFound = new FGAValidationException(FGAValidationException.Code.LATEST_AUTHORIZATION_MODEL_NOT_FOUND, "No default authorization model found");
                return Uni.createFrom().failure((Throwable)notFound);
            }
            return Uni.createFrom().item((Object)((AuthorizationModel)models.get(0)).getId());
        });
    }

    private static class StoreSearchResult {
        Optional<String> storeId;
        Optional<String> token;

        StoreSearchResult(Optional<String> storeId, Optional<String> token) {
            this.storeId = storeId;
            this.token = token;
        }

        boolean isNotFinished() {
            return this.storeId.isEmpty() && this.token.isPresent();
        }
    }
}

