/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.api;

import io.quarkiverse.openfga.client.model.FGAInternalException;
import io.quarkiverse.openfga.client.model.FGANotFoundException;
import io.quarkiverse.openfga.client.model.FGAUnknownException;
import io.quarkiverse.openfga.client.model.FGAValidationException;
import io.vertx.mutiny.ext.web.client.HttpResponse;

class Errors {
    Errors() {
    }

    static Throwable convert(HttpResponse<?> response) {
        return switch (response.statusCode()) {
            case 400 -> Errors.convertToValidationException(response);
            case 404 -> Errors.convertToNotFoundException(response);
            case 500 -> Errors.convertToInternalException(response);
            default -> new FGAUnknownException();
        };
    }

    private static FGAValidationException convertToValidationException(HttpResponse<?> response) {
        return (FGAValidationException)response.bodyAsJson(FGAValidationException.class);
    }

    private static FGANotFoundException convertToNotFoundException(HttpResponse<?> response) {
        return (FGANotFoundException)response.bodyAsJson(FGANotFoundException.class);
    }

    private static FGAInternalException convertToInternalException(HttpResponse<?> response) {
        return (FGAInternalException)response.bodyAsJson(FGAInternalException.class);
    }
}

