/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.api;

import io.quarkiverse.openfga.runtime.config.OpenFGAConfig;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class VertxWebClientFactory {
    private static final Logger log = Logger.getLogger((String)VertxWebClientFactory.class.getName());

    public static WebClient create(OpenFGAConfig config, boolean tracingEnabled, Vertx vertx, TlsConfigurationRegistry tlsRegistry) {
        URL url = config.url();
        WebClientOptions options = new WebClientOptions().setSsl("https".equals(url.getProtocol())).setDefaultHost(url.getHost()).setDefaultPort(url.getPort() != -1 ? url.getPort() : url.getDefaultPort()).setConnectTimeout((int)config.connectTimeout().toMillis()).setIdleTimeout((int)config.readTimeout().getSeconds() * 2).setTracingPolicy(tracingEnabled ? TracingPolicy.PROPAGATE : TracingPolicy.IGNORE);
        config.nonProxyHosts().ifPresent(arg_0 -> ((WebClientOptions)options).setNonProxyHosts(arg_0));
        TlsConfiguration.from((TlsConfigurationRegistry)tlsRegistry, config.tlsConfigurationName()).or(() -> ((TlsConfigurationRegistry)tlsRegistry).getDefault()).ifPresent(tlsConfig -> {
            options.setTrustOptions(tlsConfig.getTrustStoreOptions());
            options.setTrustAll(tlsConfig.isTrustAll());
            tlsConfig.getHostnameVerificationAlgorithm().ifPresent(algo -> options.setVerifyHost(algo.equals("NONE")));
            options.setKeyCertOptions(tlsConfig.getKeyStoreOptions());
            SSLOptions sslOptions = tlsConfig.getSSLOptions();
            if (sslOptions != null) {
                options.setSslHandshakeTimeout(sslOptions.getSslHandshakeTimeout());
                options.setSslHandshakeTimeoutUnit(sslOptions.getSslHandshakeTimeoutUnit());
                for (String suite : sslOptions.getEnabledCipherSuites()) {
                    options.addEnabledCipherSuite(suite);
                }
                for (Buffer buffer : sslOptions.getCrlValues()) {
                    options.addCrlValue(buffer);
                }
                options.setEnabledSecureTransportProtocols(sslOptions.getEnabledSecureTransportProtocols());
                options.setUseAlpn(sslOptions.isUseAlpn());
            }
        });
        return WebClient.create((Vertx)vertx, (WebClientOptions)options);
    }

    public static WebClient create(URL url, Vertx vertx) {
        WebClientOptions options = new WebClientOptions().setSsl("https".equals(url.getProtocol())).setDefaultHost(url.getHost()).setDefaultPort(url.getPort() != -1 ? url.getPort() : url.getDefaultPort()).setConnectTimeout((int)TimeUnit.SECONDS.toMillis(2L)).setIdleTimeout(2).setIdleTimeoutUnit(TimeUnit.SECONDS).setTrustAll(true);
        return WebClient.create((Vertx)vertx, (WebClientOptions)options);
    }

    private static void cacert(WebClientOptions options, String cacert) {
        log.debug((Object)("configure tls with " + cacert));
        options.setTrustOptions((TrustOptions)new PemTrustOptions().addCertPath(cacert));
    }

    private static void skipVerify(WebClientOptions options) {
        log.debug((Object)"configure tls with skip-verify");
        options.setTrustAll(true);
        options.setVerifyHost(false);
    }
}

