/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.utils;

import io.quarkiverse.openfga.client.model.utils.Preconditions;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

public final class PaginatedList<T> {
    private final List<T> items;
    @Nullable
    private final String token;

    public PaginatedList(List<T> items, @Nullable String token) {
        this.items = (List)Preconditions.parameterNonNull(items, (String)"items");
        this.token = token;
    }

    public Boolean isNotLastPage() {
        return this.token != null && !this.token.isEmpty();
    }

    public static <T> Uni<List<T>> collectAllPages(@Nullable Integer pageSize, BiFunction<Integer, String, Uni<PaginatedList<T>>> listGenerator) {
        return Multi.createBy().repeating().uni(AtomicReference::new, lastToken -> ((Uni)listGenerator.apply(pageSize, (String)lastToken.get())).onItem().invoke(list -> lastToken.set(list.getToken()))).whilst(PaginatedList::isNotLastPage).onItem().transformToIterable(PaginatedList::getItems).collect().asList();
    }

    public List<T> getItems() {
        return this.items;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PaginatedList that = (PaginatedList)obj;
        return Objects.equals(this.items, that.items) && Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.token);
    }

    public String toString() {
        return "PaginatedList[items=" + this.items + ", token=" + this.token + "]";
    }
}

