/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.opensearch.client.deployment;

import io.quarkiverse.opensearch.client.OpenSearchTransportConfig;
import io.quarkiverse.opensearch.client.runtime.OpenSearchClientProducer;
import io.quarkiverse.opensearch.client.runtime.OpenSearchTransportProducer;
import io.quarkiverse.opensearch.client.runtime.health.OpenSearchHealthCheck;
import io.quarkiverse.opensearch.deployment.OpenSearchBuildTimeConfig;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import org.jboss.jandex.DotName;

class OpenSearchClientProcessor {
    private static final String FEATURE = "opensearch-java-client";
    private static final DotName OPENSEARCH_TRANSPORT_CONFIG = DotName.createSimple((String)OpenSearchTransportConfig.class.getName());

    OpenSearchClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem buildOpenSearchTransportProducer() {
        return AdditionalBeanBuildItem.unremovableOf(OpenSearchTransportProducer.class);
    }

    @BuildStep
    AdditionalBeanBuildItem buildOpenSearchClientProducer() {
        return AdditionalBeanBuildItem.unremovableOf(OpenSearchClientProducer.class);
    }

    @BuildStep
    void openSearchTransportConfigSupport(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(OpenSearchTransportConfig.class).build());
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(OPENSEARCH_TRANSPORT_CONFIG, DotNames.APPLICATION_SCOPED, false));
    }

    @BuildStep
    HealthBuildItem addHealthCheck(OpenSearchBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem(OpenSearchHealthCheck.class.getName(), buildTimeConfig.healthEnabled);
    }

    @BuildStep
    ReflectiveClassBuildItem addReflectiveClassBuildItem() {
        return ReflectiveClassBuildItem.builder((String[])new String[]{"org.apache.hc.client5.http.impl.auth.BasicScheme", "org.apache.hc.client5.http.auth.UsernamePasswordCredentials", "org.apache.hc.client5.http.auth.BasicUserPrincipal", "java.lang.String", "java.util.HashMap"}).constructors().fields().methods().serialization().unsafeAllocated().build();
    }
}

