/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.opentracing.deployment;

import io.opentracing.Tracer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerResponseFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.DynamicFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.WriterInterceptorBuildItem;
import io.quarkus.smallrye.opentracing.runtime.QuarkusSmallRyeTracingDynamicFeature;
import io.quarkus.smallrye.opentracing.runtime.QuarkusSmallRyeTracingStandaloneContainerResponseFilter;
import io.quarkus.smallrye.opentracing.runtime.QuarkusSmallRyeTracingStandaloneVertxDynamicFeature;
import io.quarkus.smallrye.opentracing.runtime.TracerProducer;
import io.quarkus.undertow.deployment.FilterBuildItem;
import io.smallrye.opentracing.contrib.interceptor.OpenTracingInterceptor;
import io.smallrye.opentracing.contrib.jaxrs2.server.SpanFinishingFilter;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.servlet.DispatcherType;
import java.lang.reflect.Method;

public class SmallRyeOpenTracingProcessor {
    private static final String FEATURE = "smallrye-opentracing";

    @BuildStep
    AdditionalBeanBuildItem registerBeans(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{Tracer.class}));
        return new AdditionalBeanBuildItem(new Class[]{OpenTracingInterceptor.class, TracerProducer.class});
    }

    @BuildStep
    ReflectiveMethodBuildItem registerMethod() throws Exception {
        Method isAsync = ObserverMethod.class.getMethod("isAsync", new Class[0]);
        return new ReflectiveMethodBuildItem(isAsync);
    }

    @BuildStep
    void setupFilter(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ResteasyJaxrsProviderBuildItem> providers, BuildProducer<FilterBuildItem> filterProducer, BuildProducer<FeatureBuildItem> feature, BuildProducer<CustomContainerResponseFilterBuildItem> customResponseFilters, BuildProducer<DynamicFeatureBuildItem> dynamicFeatures, BuildProducer<WriterInterceptorBuildItem> writerInterceptors, Capabilities capabilities) {
        feature.produce((BuildItem)new FeatureBuildItem(FEATURE));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{QuarkusSmallRyeTracingDynamicFeature.class}));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QuarkusSmallRyeTracingDynamicFeature.class.getName()));
        if (capabilities.isPresent("io.quarkus.servlet")) {
            FilterBuildItem filterInfo = FilterBuildItem.builder((String)"tracingFilter", (String)SpanFinishingFilter.class.getName()).setAsyncSupported(true).addFilterUrlMapping("*", DispatcherType.FORWARD).addFilterUrlMapping("*", DispatcherType.INCLUDE).addFilterUrlMapping("*", DispatcherType.REQUEST).addFilterUrlMapping("*", DispatcherType.ASYNC).addFilterUrlMapping("*", DispatcherType.ERROR).build();
            filterProducer.produce((BuildItem)filterInfo);
        } else if (capabilities.isPresent("io.quarkus.resteasy")) {
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QuarkusSmallRyeTracingStandaloneVertxDynamicFeature.class.getName()));
        } else if (capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            customResponseFilters.produce((BuildItem)new CustomContainerResponseFilterBuildItem(QuarkusSmallRyeTracingStandaloneContainerResponseFilter.class.getName()));
            dynamicFeatures.produce((BuildItem)new DynamicFeatureBuildItem(QuarkusSmallRyeTracingDynamicFeature.class.getName()));
            writerInterceptors.produce((BuildItem)new WriterInterceptorBuildItem.Builder(QuarkusSmallRyeTracingStandaloneContainerResponseFilter.class.getName()).build());
        }
    }

    @BuildStep
    void handleKafkaIntegration(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Capabilities capabilities) {
        if (!capabilities.isPresent("io.quarkus.kafka") || !QuarkusClassLoader.isClassPresentAtRuntime((String)"io.opentracing.contrib.kafka.TracingProducerInterceptor")) {
            return;
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.opentracing.contrib.kafka.TracingProducerInterceptor", "io.opentracing.contrib.kafka.TracingConsumerInterceptor"}).methods().build());
    }

    @BuildStep
    void handleMongoDBIntegration(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses, Capabilities capabilities) {
        if (!capabilities.isPresent("io.quarkus.mongodb-client")) {
            return;
        }
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem("io.quarkus.smallrye.opentracing.runtime.integration.MongoTracingCommandListener"));
    }

    @BuildStep
    void handleRestClientIntegration(Capabilities capabilities, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (capabilities.isPresent("io.quarkus.rest.client") || capabilities.isPresent("io.quarkus.rest.client.reactive")) {
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.eclipse.microprofile.rest.client.spi.RestClientListener"}));
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.smallrye.opentracing.SmallRyeRestClientListener"}).methods().fields().build());
        }
    }
}

