/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkus.deployment.util.JandexUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public abstract class SelectiveAugmentedClassInfo {
    private final ClassInfo classInfo;
    private Type[] types;
    private final DotName extendedOrImplementedClass;
    private final int expectedParameterTypesCardinality;
    private final List<String> classNamesToRegisterForReflection = new ArrayList<String>();

    protected SelectiveAugmentedClassInfo(ClassInfo classInfo, DotName extendedOrImplementedClass, int expectedParameterTypesCardinality) {
        this.classInfo = classInfo;
        this.extendedOrImplementedClass = extendedOrImplementedClass;
        this.expectedParameterTypesCardinality = expectedParameterTypesCardinality;
    }

    public ClassInfo classInfo() {
        return this.classInfo;
    }

    protected boolean keep(IndexView index, Logger log, Map<String, Object> context) {
        String targetClassName = this.extendedOrImplementedClassName();
        DotName consideredClassName = this.classInfo.name();
        if (Modifier.isAbstract(this.classInfo.flags())) {
            log.debugv("Skipping ''{0}'' {1} because it''s abstract", (Object)consideredClassName, (Object)targetClassName);
            return false;
        }
        if (this.classInfo.annotationsMap().containsKey(Constants.IGNORE_ANNOTATION)) {
            log.debugv("Skipping ''{0}'' {1} because it''s annotated with @Ignore", (Object)consideredClassName, (Object)targetClassName);
            return false;
        }
        this.initTypesIfNeeded(index);
        return this.doKeep(index, log, context);
    }

    protected boolean doKeep(IndexView index, Logger log, Map<String, Object> context) {
        return true;
    }

    private void initTypesIfNeeded(IndexView index) {
        if (this.expectedParameterTypesCardinality > 0 && this.types == null && !Constants.OBJECT.equals((Object)this.extendedOrImplementedClass)) {
            List typeParameters;
            try {
                typeParameters = JandexUtil.resolveTypeParameters((DotName)this.classInfo.name(), (DotName)this.extendedOrImplementedClass, (IndexView)index);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot process " + this.classInfo.simpleName() + " as an implementation/extension of " + this.extendedOrImplementedClassName(), e);
            }
            if (this.expectedParameterTypesCardinality != typeParameters.size()) {
                throw new IllegalArgumentException("Cannot process " + this.classInfo.simpleName() + " as an implementation/extension of " + this.extendedOrImplementedClassName() + " because it doesn't match the expected cardinality (" + this.expectedParameterTypesCardinality + ") of type parameters");
            }
            this.types = (Type[])typeParameters.toArray(Type[]::new);
        }
    }

    public List<String> getClassNamesToRegisterForReflection() {
        return this.classNamesToRegisterForReflection;
    }

    protected void registerForReflection(String className) {
        if (className != null && !className.startsWith("java.")) {
            this.classNamesToRegisterForReflection.add(className);
        }
    }

    protected Type typeAt(int index) {
        return this.types[index];
    }

    protected String extendedOrImplementedClassName() {
        return this.extendedOrImplementedClass.local();
    }

    protected void augmentIfKept(IndexView index, Logger log, Map<String, Object> context) {
        this.initTypesIfNeeded(index);
        this.doAugment(index, log, context);
    }

    protected abstract void doAugment(IndexView var1, Logger var2, Map<String, Object> var3);
}

