/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.quarkiverse.operatorsdk.common.ClassLoadingUtils;
import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkus.bootstrap.app.ClassChangeInformation;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static <C, T> T extract(C externalConfig, AnnotationInstance annotation, Function<C, Optional<T>> extractor, String annotationField, Function<AnnotationValue, T> converter, Supplier<T> defaultValue) {
        if (externalConfig != null) {
            return extractor.apply(externalConfig).orElse(ConfigurationUtils.annotationValueOrDefault(annotation, annotationField, converter, defaultValue));
        }
        return ConfigurationUtils.annotationValueOrDefault(annotation, annotationField, converter, defaultValue);
    }

    public static <T> T annotationValueOrDefault(AnnotationInstance annotation, String annotationFieldName, Function<AnnotationValue, T> converter, Supplier<T> defaultValue) {
        return annotation != null ? Optional.ofNullable(annotation.value(annotationFieldName)).map(converter).orElseGet(defaultValue) : defaultValue.get();
    }

    public static <T> ClassInfo getClassInfoForInstantiation(AnnotationValue toInstantiate, Class<T> interfaceClass, IndexView index) {
        DotName expectedTypeDN = toInstantiate.asClass().name();
        return index.getClassByName(expectedTypeDN);
    }

    public static <T> T instantiateImplementationClass(AnnotationInstance annotation, String annotationFieldName, Class<T> interfaceClass, Class<? extends T> defaultImplementation, boolean returnNullIfDefault, IndexView index) {
        Class<? extends T> implementationClass;
        defaultImplementation = returnNullIfDefault ? null : defaultImplementation;
        Class<? extends T> clazz = implementationClass = annotation != null ? Optional.ofNullable(annotation.value(annotationFieldName)).map(av -> {
            ClassInfo expectedTypeInfo = ConfigurationUtils.getClassInfoForInstantiation(av, interfaceClass, index);
            String typeName = expectedTypeInfo.name().toString();
            return ClassLoadingUtils.loadClass((String)typeName, (Class)interfaceClass);
        }).orElse(defaultImplementation) : defaultImplementation;
        if (returnNullIfDefault && implementationClass == null) {
            return null;
        }
        return (T)ClassLoadingUtils.instantiate(implementationClass);
    }

    public static boolean shouldValidateCustomResources(boolean validate) {
        if (Utils.isValidateCustomResourcesEnvVarSet()) {
            return Utils.shouldCheckCRDAndValidateLocalModel();
        }
        return validate;
    }

    public static String getReconcilerName(ClassInfo info) {
        String controllerClassName = info.name().toString();
        AnnotationInstance controllerAnnotation = info.declaredAnnotation(Constants.CONTROLLER_CONFIGURATION);
        return ConfigurationUtils.getReconcilerName(controllerClassName, controllerAnnotation);
    }

    public static String getReconcilerName(String reconcilerClassName, AnnotationInstance configuration) {
        String defaultControllerName = ReconcilerUtils.getDefaultReconcilerName((String)reconcilerClassName);
        return ConfigurationUtils.annotationValueOrDefault(configuration, "name", AnnotationValue::asString, () -> defaultControllerName);
    }

    public static Set<String> getChangedClasses(LiveReloadBuildItem liveReload) {
        return liveReload.isLiveReload() ? Optional.ofNullable(liveReload.getChangeInformation()).map(ClassChangeInformation::getChangedClasses).orElse(Collections.emptySet()) : Collections.emptySet();
    }
}

