/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.fabric8.kubernetes.api.Pluralize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Singular;
import io.fabric8.kubernetes.model.annotation.Version;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import java.util.Locale;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class HasMetadataUtils {
    private static final DotName GROUP = DotName.createSimple((String)Group.class.getName());
    private static final DotName PLURAL = DotName.createSimple((String)Plural.class.getName());
    private static final DotName SINGULAR = DotName.createSimple((String)Singular.class.getName());
    private static final DotName KIND = DotName.createSimple((String)Kind.class.getName());
    private static final DotName VERSION = DotName.createSimple((String)Version.class.getName());

    public static String getFullResourceName(ClassInfo resourceCI) {
        return HasMetadata.getFullResourceName((String)HasMetadataUtils.getPlural(resourceCI), (String)HasMetadataUtils.getGroup(resourceCI));
    }

    public static String getPlural(ClassInfo resourceCI) {
        return ConfigurationUtils.annotationValueOrDefault(resourceCI.declaredAnnotation(PLURAL), "value", value -> value.asString().toLowerCase(Locale.ROOT), () -> Pluralize.toPlural((String)HasMetadataUtils.getSingular(resourceCI)));
    }

    public static String getGroup(ClassInfo resourceCI) {
        return ConfigurationUtils.annotationValueOrDefault(resourceCI.declaredAnnotation(GROUP), "value", AnnotationValue::asString, () -> null);
    }

    public static String getSingular(ClassInfo resourceCI) {
        return ConfigurationUtils.annotationValueOrDefault(resourceCI.declaredAnnotation(SINGULAR), "value", AnnotationValue::asString, () -> HasMetadataUtils.getKind(resourceCI).toLowerCase(Locale.ROOT));
    }

    public static String getKind(ClassInfo resourceCI) {
        return ConfigurationUtils.annotationValueOrDefault(resourceCI.declaredAnnotation(KIND), "value", AnnotationValue::asString, () -> ((ClassInfo)resourceCI).simpleName());
    }

    public static String getVersion(ClassInfo resourceCI) {
        return ConfigurationUtils.annotationValueOrDefault(resourceCI.declaredAnnotation(VERSION), "value", AnnotationValue::asString, () -> null);
    }
}

