/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkiverse.operatorsdk.common.HasMetadataUtils;
import io.quarkiverse.operatorsdk.common.ReconciledAugmentedClassInfo;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class ReconciledResourceAugmentedClassInfo<T extends HasMetadata>
extends ReconciledAugmentedClassInfo<T> {
    public static final String STATUS = "status";
    protected boolean hasStatus;

    protected ReconciledResourceAugmentedClassInfo(ClassInfo classInfo, DotName extendedOrImplementedClass, int expectedParameterTypesCardinality, String associatedReconcilerName) {
        super(classInfo, extendedOrImplementedClass, expectedParameterTypesCardinality, associatedReconcilerName);
    }

    public String fullResourceName() {
        return HasMetadataUtils.getFullResourceName(this.classInfo());
    }

    public String kind() {
        return HasMetadataUtils.getKind(this.classInfo());
    }

    public String version() {
        return HasMetadataUtils.getVersion(this.classInfo());
    }

    public String group() {
        return HasMetadataUtils.getGroup(this.classInfo());
    }

    @Override
    public boolean isResource() {
        return true;
    }

    @Override
    protected void doAugment(IndexView index, Logger log, Map<String, Object> context) {
        super.doAugment(index, log, context);
        this.hasStatus = this.hasStatus(index);
    }

    protected boolean hasStatus(IndexView index) {
        return ClassUtils.hasField(index, this.classInfo(), STATUS);
    }

    public boolean hasNonVoidStatus() {
        return this.hasStatus;
    }
}

