/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.quarkiverse.operatorsdk.common.FileUtils;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class GeneratedResourcesUtils {
    public static final String KUBERNETES_YAML = "kubernetes.yml";
    private static final Logger log = Logger.getLogger((String)GeneratedResourcesUtils.class.getName());

    public static List<HasMetadata> loadFrom(List<GeneratedKubernetesResourceBuildItem> generatedResources, String resourceName) {
        if (generatedResources.isEmpty()) {
            log.debugv("Couldn't load resource {0} because no resources were generated", (Object)resourceName);
            return Collections.emptyList();
        }
        Optional<GeneratedKubernetesResourceBuildItem> buildItem = generatedResources.stream().filter(r -> resourceName.equals(r.getName())).findAny();
        return buildItem.map(bi -> FileUtils.unmarshalFrom(bi.getContent())).orElseThrow(() -> new IllegalArgumentException("Couldn't find resource " + resourceName + " in generated resources: " + generatedResources.stream().map(GeneratedKubernetesResourceBuildItem::getName).collect(Collectors.toSet())));
    }

    public static List<HasMetadata> loadFrom(List<GeneratedKubernetesResourceBuildItem> generatedResources) {
        return GeneratedResourcesUtils.loadFrom(generatedResources, KUBERNETES_YAML);
    }
}

