/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.fabric8.kubernetes.client.CustomResource;
import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkiverse.operatorsdk.common.ReconciledResourceAugmentedClassInfo;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class CustomResourceAugmentedClassInfo
extends ReconciledResourceAugmentedClassInfo<CustomResource<?, ?>> {
    public static final String EXISTING_CRDS_KEY = "existing-crds-key";

    protected CustomResourceAugmentedClassInfo(ClassInfo classInfo, String associatedReconcilerName) {
        super(classInfo, Constants.CUSTOM_RESOURCE, 2, associatedReconcilerName);
    }

    @Override
    protected boolean doKeep(IndexView index, Logger log, Map<String, Object> context) {
        String fullName = this.fullResourceName();
        return Optional.ofNullable(context.get(EXISTING_CRDS_KEY)).map(value -> {
            Set generated = (Set)value;
            return !generated.contains(fullName);
        }).orElse(true);
    }

    @Override
    protected void doAugment(IndexView index, Logger log, Map<String, Object> context) {
        super.doAugment(index, log, context);
        String specClassName = this.typeAt(0).name().toString();
        String statusClassName = this.typeAt(1).name().toString();
        this.registerForReflection(specClassName);
        this.registerForReflection(statusClassName);
    }

    @Override
    protected boolean hasStatus(IndexView index) {
        String statusClassName = this.typeAt(1).name().toString();
        return ClassUtils.isStatusNotVoid(statusClassName);
    }

    @Override
    public boolean isCR() {
        return true;
    }
}

