/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.quarkiverse.operatorsdk.common.ConfigurationUtils;
import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkiverse.operatorsdk.common.DependentResourceAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ResourceAssociatedAugmentedClassInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class ReconcilerAugmentedClassInfo
extends ResourceAssociatedAugmentedClassInfo {
    private Collection<DependentResourceAugmentedClassInfo> dependentResourceInfos;

    public ReconcilerAugmentedClassInfo(ClassInfo classInfo) {
        super(classInfo, Constants.RECONCILER, 1, ConfigurationUtils.getReconcilerName(classInfo));
    }

    @Override
    protected boolean doKeep(IndexView index, Logger log, Map<String, Object> context) {
        DotName primaryTypeDN = this.resourceTypeName();
        if (primaryTypeDN.toString() == null || Constants.CUSTOM_RESOURCE.equals((Object)primaryTypeDN) || Constants.HAS_METADATA.equals((Object)primaryTypeDN)) {
            log.warnv("Skipped processing of ''{0}'' {1} as it''s not parameterized with a CustomResource or HasMetadata sub-class", this.name(), (Object)this.extendedOrImplementedClassName());
            return false;
        }
        return true;
    }

    @Override
    protected void doAugment(IndexView index, Logger log, Map<String, Object> context) {
        AnnotationValue dependents;
        super.doAugment(index, log, context);
        ClassInfo reconciler = this.classInfo();
        AnnotationInstance workflow = reconciler.declaredAnnotation(Constants.WORKFLOW);
        this.dependentResourceInfos = Collections.emptyList();
        if (workflow != null && (dependents = workflow.value("dependents")) != null) {
            AnnotationInstance[] dependentAnnotations = dependents.asNestedArray();
            Map<String, DependentResourceAugmentedClassInfo> dependentResources = Collections.emptyMap();
            dependentResources = new LinkedHashMap(dependentAnnotations.length);
            for (AnnotationInstance dependentConfig : dependentAnnotations) {
                ClassInfo dependentType = ConfigurationUtils.getClassInfoForInstantiation(dependentConfig.value("type"), DependentResource.class, index);
                DependentResourceAugmentedClassInfo dependent = DependentResourceAugmentedClassInfo.createFor(dependentType, dependentConfig, index, log, context, this.nameOrFailIfUnset());
                String dependentName = dependent.nameOrFailIfUnset();
                String dependentTypeName = dependentType.name().toString();
                if (dependentResources.containsKey(dependentName)) {
                    throw new IllegalArgumentException("A DependentResource named: " + dependentName + " already exists: " + dependentTypeName);
                }
                dependentResources.put(dependentName, dependent);
                this.registerForReflection(dependentTypeName);
            }
            this.dependentResourceInfos = dependentResources.values();
        }
    }

    public Collection<DependentResourceAugmentedClassInfo> getDependentResourceInfos() {
        return this.dependentResourceInfos;
    }
}

